/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataDomainDBDiffBuilder;
import org.apache.cayenne.access.DataDomainFlushAction;
import org.apache.cayenne.access.DataDomainSyncBucket;
import org.apache.cayenne.access.DataNodeSyncQualifierDescriptor;
import org.apache.cayenne.access.DbEntityClassDescriptor;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.UpdateBatchQuery;

class DataDomainUpdateBucket
extends DataDomainSyncBucket {
    DataDomainUpdateBucket(DataDomainFlushAction parent) {
        super(parent);
    }

    @Override
    void appendQueriesInternal(Collection<Query> queries) {
        DataDomainDBDiffBuilder diffBuilder = new DataDomainDBDiffBuilder();
        DataNodeSyncQualifierDescriptor qualifierBuilder = new DataNodeSyncQualifierDescriptor();
        for (DbEntity dbEntity : this.dbEntities) {
            Collection descriptors = (Collection)this.descriptorsByDbEntity.get(dbEntity);
            LinkedHashMap<List<Set>, UpdateBatchQuery> batches = new LinkedHashMap<List<Set>, UpdateBatchQuery>();
            for (DbEntityClassDescriptor descriptor : descriptors) {
                ObjEntity entity = descriptor.getEntity();
                diffBuilder.reset(descriptor);
                qualifierBuilder.reset(descriptor);
                boolean isRootDbEntity = entity.getDbEntity() == dbEntity;
                for (Persistent o : (List)this.objectsByDescriptor.get(descriptor.getClassDescriptor())) {
                    ObjectDiff diff = this.parent.objectDiff(o.getObjectId());
                    Map<String, Object> snapshot = diffBuilder.buildDBDiff(diff);
                    if (snapshot == null) continue;
                    this.checkReadOnly(entity);
                    Map<String, Object> qualifierSnapshot = qualifierBuilder.createQualifierSnapshot(diff);
                    Set<String> snapshotSet = snapshot.keySet();
                    HashSet<String> nullQualifierNames = new HashSet<String>();
                    for (Map.Entry<String, Object> entry : qualifierSnapshot.entrySet()) {
                        if (entry.getValue() != null) continue;
                        nullQualifierNames.add(entry.getKey());
                    }
                    List<Set> batchKey = Arrays.asList(snapshotSet, nullQualifierNames);
                    UpdateBatchQuery batch = (UpdateBatchQuery)batches.get(batchKey);
                    if (batch == null) {
                        batch = new UpdateBatchQuery(dbEntity, qualifierBuilder.getAttributes(), this.updatedAttributes(dbEntity, snapshot), nullQualifierNames, 10);
                        batch.setUsingOptimisticLocking(qualifierBuilder.isUsingOptimisticLocking());
                        batches.put(batchKey, batch);
                    }
                    batch.add(qualifierSnapshot, snapshot, o.getObjectId());
                    if (!isRootDbEntity) continue;
                    Map<String, Object> replacementId = o.getObjectId().getReplacementIdMap();
                    for (DbAttribute pk : dbEntity.getPrimaryKeys()) {
                        String name = pk.getName();
                        if (!snapshot.containsKey(name) || replacementId.containsKey(name)) continue;
                        replacementId.put(name, snapshot.get(name));
                    }
                }
            }
            queries.addAll(batches.values());
        }
    }

    private List updatedAttributes(DbEntity entity, Map updatedSnapshot) {
        ArrayList attributes = new ArrayList(updatedSnapshot.size());
        SortedMap<String, ? extends Attribute> entityAttributes = entity.getAttributeMap();
        for (Object name : updatedSnapshot.keySet()) {
            attributes.add(entityAttributes.get(name));
        }
        return attributes;
    }
}

