/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.util.EqualsBuilder;
import org.apache.cayenne.util.HashCodeBuilder;
import org.apache.cayenne.util.IDUtil;
import org.apache.cayenne.util.Util;

public class ObjectId
implements Serializable {
    private static final long serialVersionUID = -2265029098344119323L;
    protected String entityName;
    protected Map<String, Object> objectIdKeys;
    private String singleKey;
    private Object singleValue;
    protected byte[] key;
    protected Map<String, Object> replacementIdMap;
    transient int hashCode;

    private ObjectId() {
    }

    public ObjectId(String entityName) {
        this(entityName, IDUtil.pseudoUniqueByteSequence8());
    }

    public ObjectId(String entityName, byte[] key) {
        this.entityName = entityName;
        this.key = key;
    }

    public ObjectId(String entityName, String key, int value) {
        this(entityName, key, (Object)value);
    }

    public ObjectId(String entityName, String key, Object value) {
        this.entityName = entityName;
        this.singleKey = key;
        this.singleValue = value;
    }

    public ObjectId(String entityName, Map<String, ?> idMap) {
        this.entityName = entityName;
        if (idMap != null && idMap.size() != 0) {
            if (idMap.size() == 1) {
                Map.Entry<String, ?> e = idMap.entrySet().iterator().next();
                this.singleKey = String.valueOf(e.getKey());
                this.singleValue = e.getValue();
            } else {
                this.objectIdKeys = new HashMap(idMap);
            }
        }
    }

    public boolean isTemporary() {
        return this.key != null;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public byte[] getKey() {
        return this.key;
    }

    public Map<String, Object> getIdSnapshot() {
        if (this.isTemporary()) {
            return this.replacementIdMap == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this.replacementIdMap);
        }
        if (this.singleKey != null) {
            return Collections.singletonMap(this.singleKey, this.singleValue);
        }
        return this.objectIdKeys != null ? Collections.unmodifiableMap(this.objectIdKeys) : Collections.EMPTY_MAP;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectId)) {
            return false;
        }
        ObjectId id = (ObjectId)object;
        if (!Util.nullSafeEquals(this.entityName, id.entityName)) {
            return false;
        }
        if (this.isTemporary()) {
            return new EqualsBuilder().append(this.key, id.key).isEquals();
        }
        if (this.singleKey != null) {
            return Util.nullSafeEquals(this.singleKey, id.singleKey) && this.valueEquals(this.singleValue, id.singleValue);
        }
        if (id.objectIdKeys == null) {
            return this.objectIdKeys == null;
        }
        if (id.objectIdKeys.size() != this.objectIdKeys.size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.objectIdKeys.entrySet()) {
            String entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            if (!(entryValue == null ? id.objectIdKeys.get(entryKey) != null || !id.objectIdKeys.containsKey(entryKey) : !this.valueEquals(entryValue, id.objectIdKeys.get(entryKey)))) continue;
            return false;
        }
        return true;
    }

    private final boolean valueEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        if (o1 instanceof Number) {
            return o2 instanceof Number && ((Number)o1).longValue() == ((Number)o2).longValue();
        }
        if (o1.getClass().isArray()) {
            return new EqualsBuilder().append(o1, o2).isEquals();
        }
        return Util.nullSafeEquals(o1, o2);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeBuilder builder = new HashCodeBuilder(3, 5);
            builder.append(this.entityName.hashCode());
            if (this.key != null) {
                builder.append(this.key);
            } else if (this.singleKey != null) {
                builder.append(this.singleKey.hashCode());
                if (this.singleValue instanceof Number) {
                    builder.append(((Number)this.singleValue).longValue());
                } else {
                    builder.append(this.singleValue);
                }
            } else if (this.objectIdKeys != null) {
                int len = this.objectIdKeys.size();
                Object[] keys = this.objectIdKeys.keySet().toArray();
                Arrays.sort(keys);
                for (int i = 0; i < len; ++i) {
                    builder.append(i);
                    Object value = this.objectIdKeys.get(keys[i]);
                    if (value instanceof Number) {
                        builder.append(((Number)value).longValue());
                        continue;
                    }
                    builder.append(value);
                }
            }
            this.hashCode = builder.toHashCode();
            assert (this.hashCode != 0) : "Generated zero hashCode";
        }
        return this.hashCode;
    }

    public Map<String, Object> getReplacementIdMap() {
        if (this.replacementIdMap == null) {
            this.replacementIdMap = new HashMap<String, Object>();
        }
        return this.replacementIdMap;
    }

    public ObjectId createReplacementId() {
        HashMap<String, Object> newIdMap = new HashMap<String, Object>(this.getIdSnapshot());
        if (this.replacementIdMap != null) {
            newIdMap.putAll(this.replacementIdMap);
        }
        return new ObjectId(this.getEntityName(), newIdMap);
    }

    public boolean isReplacementIdAttached() {
        return this.replacementIdMap != null && !this.replacementIdMap.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<ObjectId:").append(this.entityName);
        if (this.isTemporary()) {
            void var4_7;
            buffer.append(", TEMP:");
            byte[] byArray = this.key;
            int n = byArray.length;
            boolean bl = false;
            while (var4_7 < n) {
                byte aKey = byArray[var4_7];
                IDUtil.appendFormattedByte(buffer, aKey);
                ++var4_7;
            }
        } else if (this.singleKey != null) {
            buffer.append(", ").append(String.valueOf(this.singleKey)).append("=").append(this.singleValue);
        } else if (this.objectIdKeys != null) {
            ArrayList<String> keys = new ArrayList<String>(this.objectIdKeys.keySet());
            Collections.sort(keys);
            for (Object e : keys) {
                buffer.append(", ");
                buffer.append(String.valueOf(e)).append("=").append(this.objectIdKeys.get(e));
            }
        }
        buffer.append(">");
        return buffer.toString();
    }
}

