/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.Arrays;
import java.util.Random;
import org.apache.cayenne.util.Base64Codec;
import org.junit.Assert;
import org.junit.Test;

public class Base64CodecTest {
    private Random _random = new Random();

    @Test
    public void testBase64() {
        String content = "Hello World";
        String encodedContent = new String(Base64Codec.encodeBase64(content.getBytes()));
        Assert.assertTrue((String)"encoding hello world", (boolean)encodedContent.equals("SGVsbG8gV29ybGQ="));
    }

    @Test
    public void testDecodePadMarkerIndex2() {
        Assert.assertEquals((Object)"A", (Object)new String(Base64Codec.decodeBase64("QQ==".getBytes())));
    }

    @Test
    public void testDecodePadMarkerIndex3() {
        Assert.assertEquals((Object)"AA", (Object)new String(Base64Codec.decodeBase64("QUE=".getBytes())));
        Assert.assertEquals((Object)"AAA", (Object)new String(Base64Codec.decodeBase64("QUFB".getBytes())));
    }

    @Test
    public void testDecodePadOnly() {
        Assert.assertTrue((Base64Codec.decodeBase64("====".getBytes()).length == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"", (Object)new String(Base64Codec.decodeBase64("====".getBytes())));
    }

    @Test
    public void testDecodePadOnlyChunked() {
        Assert.assertTrue((Base64Codec.decodeBase64("====\n".getBytes()).length == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"", (Object)new String(Base64Codec.decodeBase64("====\n".getBytes())));
    }

    @Test
    public void testEncodeDecodeSmall() {
        for (int i = 0; i < 12; ++i) {
            byte[] data = new byte[i];
            this.getRandom().nextBytes(data);
            byte[] enc = Base64Codec.encodeBase64(data);
            Assert.assertTrue((String)("\"" + new String(enc) + "\" is Base64 data."), (boolean)Base64Codec.isArrayByteBase64(enc));
            byte[] data2 = Base64Codec.decodeBase64(enc);
            Assert.assertTrue((String)(this.toString(data) + " equals " + this.toString(data2)), (boolean)Arrays.equals(data, data2));
        }
    }

    @Test
    public void testEncodeDecodeRandom() {
        for (int i = 1; i < 5; ++i) {
            byte[] data = new byte[this.getRandom().nextInt(10000) + 1];
            this.getRandom().nextBytes(data);
            byte[] enc = Base64Codec.encodeBase64(data);
            Assert.assertTrue((boolean)Base64Codec.isArrayByteBase64(enc));
            byte[] data2 = Base64Codec.decodeBase64(enc);
            Assert.assertTrue((boolean)Arrays.equals(data, data2));
        }
    }

    @Test
    public void testRfc2045Section2Dot1CrLfDefinition() {
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{13, 10}, Base64Codec.CHUNK_SEPARATOR));
    }

    @Test
    public void testRfc2045Section6Dot8ChunkSizeDefinition() {
        Assert.assertEquals((long)76L, (long)76L);
    }

    @Test
    public void testSingletons() {
        Assert.assertEquals((Object)"AA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{0})));
        Assert.assertEquals((Object)"AQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{1})));
        Assert.assertEquals((Object)"Ag==", (Object)new String(Base64Codec.encodeBase64(new byte[]{2})));
        Assert.assertEquals((Object)"Aw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{3})));
        Assert.assertEquals((Object)"BA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{4})));
        Assert.assertEquals((Object)"BQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{5})));
        Assert.assertEquals((Object)"Bg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{6})));
        Assert.assertEquals((Object)"Bw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{7})));
        Assert.assertEquals((Object)"CA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{8})));
        Assert.assertEquals((Object)"CQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{9})));
        Assert.assertEquals((Object)"Cg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{10})));
        Assert.assertEquals((Object)"Cw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{11})));
        Assert.assertEquals((Object)"DA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{12})));
        Assert.assertEquals((Object)"DQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{13})));
        Assert.assertEquals((Object)"Dg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{14})));
        Assert.assertEquals((Object)"Dw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{15})));
        Assert.assertEquals((Object)"EA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{16})));
        Assert.assertEquals((Object)"EQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{17})));
        Assert.assertEquals((Object)"Eg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{18})));
        Assert.assertEquals((Object)"Ew==", (Object)new String(Base64Codec.encodeBase64(new byte[]{19})));
        Assert.assertEquals((Object)"FA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{20})));
        Assert.assertEquals((Object)"FQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{21})));
        Assert.assertEquals((Object)"Fg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{22})));
        Assert.assertEquals((Object)"Fw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{23})));
        Assert.assertEquals((Object)"GA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{24})));
        Assert.assertEquals((Object)"GQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{25})));
        Assert.assertEquals((Object)"Gg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{26})));
        Assert.assertEquals((Object)"Gw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{27})));
        Assert.assertEquals((Object)"HA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{28})));
        Assert.assertEquals((Object)"HQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{29})));
        Assert.assertEquals((Object)"Hg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{30})));
        Assert.assertEquals((Object)"Hw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{31})));
        Assert.assertEquals((Object)"IA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{32})));
        Assert.assertEquals((Object)"IQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{33})));
        Assert.assertEquals((Object)"Ig==", (Object)new String(Base64Codec.encodeBase64(new byte[]{34})));
        Assert.assertEquals((Object)"Iw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{35})));
        Assert.assertEquals((Object)"JA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{36})));
        Assert.assertEquals((Object)"JQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{37})));
        Assert.assertEquals((Object)"Jg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{38})));
        Assert.assertEquals((Object)"Jw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{39})));
        Assert.assertEquals((Object)"KA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{40})));
        Assert.assertEquals((Object)"KQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{41})));
        Assert.assertEquals((Object)"Kg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{42})));
        Assert.assertEquals((Object)"Kw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{43})));
        Assert.assertEquals((Object)"LA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{44})));
        Assert.assertEquals((Object)"LQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{45})));
        Assert.assertEquals((Object)"Lg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{46})));
        Assert.assertEquals((Object)"Lw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{47})));
        Assert.assertEquals((Object)"MA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{48})));
        Assert.assertEquals((Object)"MQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{49})));
        Assert.assertEquals((Object)"Mg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{50})));
        Assert.assertEquals((Object)"Mw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{51})));
        Assert.assertEquals((Object)"NA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{52})));
        Assert.assertEquals((Object)"NQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{53})));
        Assert.assertEquals((Object)"Ng==", (Object)new String(Base64Codec.encodeBase64(new byte[]{54})));
        Assert.assertEquals((Object)"Nw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{55})));
        Assert.assertEquals((Object)"OA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{56})));
        Assert.assertEquals((Object)"OQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{57})));
        Assert.assertEquals((Object)"Og==", (Object)new String(Base64Codec.encodeBase64(new byte[]{58})));
        Assert.assertEquals((Object)"Ow==", (Object)new String(Base64Codec.encodeBase64(new byte[]{59})));
        Assert.assertEquals((Object)"PA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{60})));
        Assert.assertEquals((Object)"PQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{61})));
        Assert.assertEquals((Object)"Pg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{62})));
        Assert.assertEquals((Object)"Pw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{63})));
        Assert.assertEquals((Object)"QA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{64})));
        Assert.assertEquals((Object)"QQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{65})));
        Assert.assertEquals((Object)"Qg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{66})));
        Assert.assertEquals((Object)"Qw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{67})));
        Assert.assertEquals((Object)"RA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{68})));
        Assert.assertEquals((Object)"RQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{69})));
        Assert.assertEquals((Object)"Rg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{70})));
        Assert.assertEquals((Object)"Rw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{71})));
        Assert.assertEquals((Object)"SA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{72})));
        Assert.assertEquals((Object)"SQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{73})));
        Assert.assertEquals((Object)"Sg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{74})));
        Assert.assertEquals((Object)"Sw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{75})));
        Assert.assertEquals((Object)"TA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{76})));
        Assert.assertEquals((Object)"TQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{77})));
        Assert.assertEquals((Object)"Tg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{78})));
        Assert.assertEquals((Object)"Tw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{79})));
        Assert.assertEquals((Object)"UA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{80})));
        Assert.assertEquals((Object)"UQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{81})));
        Assert.assertEquals((Object)"Ug==", (Object)new String(Base64Codec.encodeBase64(new byte[]{82})));
        Assert.assertEquals((Object)"Uw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{83})));
        Assert.assertEquals((Object)"VA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{84})));
        Assert.assertEquals((Object)"VQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{85})));
        Assert.assertEquals((Object)"Vg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{86})));
        Assert.assertEquals((Object)"Vw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{87})));
        Assert.assertEquals((Object)"WA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{88})));
        Assert.assertEquals((Object)"WQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{89})));
        Assert.assertEquals((Object)"Wg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{90})));
        Assert.assertEquals((Object)"Ww==", (Object)new String(Base64Codec.encodeBase64(new byte[]{91})));
        Assert.assertEquals((Object)"XA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{92})));
        Assert.assertEquals((Object)"XQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{93})));
        Assert.assertEquals((Object)"Xg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{94})));
        Assert.assertEquals((Object)"Xw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{95})));
        Assert.assertEquals((Object)"YA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{96})));
        Assert.assertEquals((Object)"YQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{97})));
        Assert.assertEquals((Object)"Yg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{98})));
        Assert.assertEquals((Object)"Yw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{99})));
        Assert.assertEquals((Object)"ZA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{100})));
        Assert.assertEquals((Object)"ZQ==", (Object)new String(Base64Codec.encodeBase64(new byte[]{101})));
        Assert.assertEquals((Object)"Zg==", (Object)new String(Base64Codec.encodeBase64(new byte[]{102})));
        Assert.assertEquals((Object)"Zw==", (Object)new String(Base64Codec.encodeBase64(new byte[]{103})));
        Assert.assertEquals((Object)"aA==", (Object)new String(Base64Codec.encodeBase64(new byte[]{104})));
    }

    @Test
    public void testSingletonsChunked() {
        Assert.assertEquals((Object)"AA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0})));
        Assert.assertEquals((Object)"AQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{1})));
        Assert.assertEquals((Object)"Ag==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{2})));
        Assert.assertEquals((Object)"Aw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{3})));
        Assert.assertEquals((Object)"BA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{4})));
        Assert.assertEquals((Object)"BQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{5})));
        Assert.assertEquals((Object)"Bg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{6})));
        Assert.assertEquals((Object)"Bw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{7})));
        Assert.assertEquals((Object)"CA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{8})));
        Assert.assertEquals((Object)"CQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{9})));
        Assert.assertEquals((Object)"Cg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{10})));
        Assert.assertEquals((Object)"Cw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{11})));
        Assert.assertEquals((Object)"DA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{12})));
        Assert.assertEquals((Object)"DQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{13})));
        Assert.assertEquals((Object)"Dg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{14})));
        Assert.assertEquals((Object)"Dw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{15})));
        Assert.assertEquals((Object)"EA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{16})));
        Assert.assertEquals((Object)"EQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{17})));
        Assert.assertEquals((Object)"Eg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{18})));
        Assert.assertEquals((Object)"Ew==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{19})));
        Assert.assertEquals((Object)"FA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{20})));
        Assert.assertEquals((Object)"FQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{21})));
        Assert.assertEquals((Object)"Fg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{22})));
        Assert.assertEquals((Object)"Fw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{23})));
        Assert.assertEquals((Object)"GA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{24})));
        Assert.assertEquals((Object)"GQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{25})));
        Assert.assertEquals((Object)"Gg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{26})));
        Assert.assertEquals((Object)"Gw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{27})));
        Assert.assertEquals((Object)"HA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{28})));
        Assert.assertEquals((Object)"HQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{29})));
        Assert.assertEquals((Object)"Hg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{30})));
        Assert.assertEquals((Object)"Hw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{31})));
        Assert.assertEquals((Object)"IA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{32})));
        Assert.assertEquals((Object)"IQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{33})));
        Assert.assertEquals((Object)"Ig==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{34})));
        Assert.assertEquals((Object)"Iw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{35})));
        Assert.assertEquals((Object)"JA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{36})));
        Assert.assertEquals((Object)"JQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{37})));
        Assert.assertEquals((Object)"Jg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{38})));
        Assert.assertEquals((Object)"Jw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{39})));
        Assert.assertEquals((Object)"KA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{40})));
        Assert.assertEquals((Object)"KQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{41})));
        Assert.assertEquals((Object)"Kg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{42})));
        Assert.assertEquals((Object)"Kw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{43})));
        Assert.assertEquals((Object)"LA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{44})));
        Assert.assertEquals((Object)"LQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{45})));
        Assert.assertEquals((Object)"Lg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{46})));
        Assert.assertEquals((Object)"Lw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{47})));
        Assert.assertEquals((Object)"MA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{48})));
        Assert.assertEquals((Object)"MQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{49})));
        Assert.assertEquals((Object)"Mg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{50})));
        Assert.assertEquals((Object)"Mw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{51})));
        Assert.assertEquals((Object)"NA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{52})));
        Assert.assertEquals((Object)"NQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{53})));
        Assert.assertEquals((Object)"Ng==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{54})));
        Assert.assertEquals((Object)"Nw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{55})));
        Assert.assertEquals((Object)"OA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{56})));
        Assert.assertEquals((Object)"OQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{57})));
        Assert.assertEquals((Object)"Og==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{58})));
        Assert.assertEquals((Object)"Ow==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{59})));
        Assert.assertEquals((Object)"PA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{60})));
        Assert.assertEquals((Object)"PQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{61})));
        Assert.assertEquals((Object)"Pg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{62})));
        Assert.assertEquals((Object)"Pw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{63})));
        Assert.assertEquals((Object)"QA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{64})));
        Assert.assertEquals((Object)"QQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{65})));
        Assert.assertEquals((Object)"Qg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{66})));
        Assert.assertEquals((Object)"Qw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{67})));
        Assert.assertEquals((Object)"RA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{68})));
        Assert.assertEquals((Object)"RQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{69})));
        Assert.assertEquals((Object)"Rg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{70})));
        Assert.assertEquals((Object)"Rw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{71})));
        Assert.assertEquals((Object)"SA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{72})));
        Assert.assertEquals((Object)"SQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{73})));
        Assert.assertEquals((Object)"Sg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{74})));
        Assert.assertEquals((Object)"Sw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{75})));
        Assert.assertEquals((Object)"TA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{76})));
        Assert.assertEquals((Object)"TQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{77})));
        Assert.assertEquals((Object)"Tg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{78})));
        Assert.assertEquals((Object)"Tw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{79})));
        Assert.assertEquals((Object)"UA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{80})));
        Assert.assertEquals((Object)"UQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{81})));
        Assert.assertEquals((Object)"Ug==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{82})));
        Assert.assertEquals((Object)"Uw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{83})));
        Assert.assertEquals((Object)"VA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{84})));
        Assert.assertEquals((Object)"VQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{85})));
        Assert.assertEquals((Object)"Vg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{86})));
        Assert.assertEquals((Object)"Vw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{87})));
        Assert.assertEquals((Object)"WA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{88})));
        Assert.assertEquals((Object)"WQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{89})));
        Assert.assertEquals((Object)"Wg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{90})));
        Assert.assertEquals((Object)"Ww==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{91})));
        Assert.assertEquals((Object)"XA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{92})));
        Assert.assertEquals((Object)"XQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{93})));
        Assert.assertEquals((Object)"Xg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{94})));
        Assert.assertEquals((Object)"Xw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{95})));
        Assert.assertEquals((Object)"YA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{96})));
        Assert.assertEquals((Object)"YQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{97})));
        Assert.assertEquals((Object)"Yg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{98})));
        Assert.assertEquals((Object)"Yw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{99})));
        Assert.assertEquals((Object)"ZA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{100})));
        Assert.assertEquals((Object)"ZQ==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{101})));
        Assert.assertEquals((Object)"Zg==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{102})));
        Assert.assertEquals((Object)"Zw==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{103})));
        Assert.assertEquals((Object)"aA==\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{104})));
    }

    @Test
    public void testTriplets() {
        Assert.assertEquals((Object)"AAAA", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 0})));
        Assert.assertEquals((Object)"AAAB", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 1})));
        Assert.assertEquals((Object)"AAAC", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 2})));
        Assert.assertEquals((Object)"AAAD", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 3})));
        Assert.assertEquals((Object)"AAAE", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 4})));
        Assert.assertEquals((Object)"AAAF", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 5})));
        Assert.assertEquals((Object)"AAAG", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 6})));
        Assert.assertEquals((Object)"AAAH", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 7})));
        Assert.assertEquals((Object)"AAAI", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 8})));
        Assert.assertEquals((Object)"AAAJ", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 9})));
        Assert.assertEquals((Object)"AAAK", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 10})));
        Assert.assertEquals((Object)"AAAL", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 11})));
        Assert.assertEquals((Object)"AAAM", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 12})));
        Assert.assertEquals((Object)"AAAN", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 13})));
        Assert.assertEquals((Object)"AAAO", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 14})));
        Assert.assertEquals((Object)"AAAP", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 15})));
        Assert.assertEquals((Object)"AAAQ", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 16})));
        Assert.assertEquals((Object)"AAAR", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 17})));
        Assert.assertEquals((Object)"AAAS", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 18})));
        Assert.assertEquals((Object)"AAAT", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 19})));
        Assert.assertEquals((Object)"AAAU", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 20})));
        Assert.assertEquals((Object)"AAAV", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 21})));
        Assert.assertEquals((Object)"AAAW", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 22})));
        Assert.assertEquals((Object)"AAAX", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 23})));
        Assert.assertEquals((Object)"AAAY", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 24})));
        Assert.assertEquals((Object)"AAAZ", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 25})));
        Assert.assertEquals((Object)"AAAa", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 26})));
        Assert.assertEquals((Object)"AAAb", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 27})));
        Assert.assertEquals((Object)"AAAc", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 28})));
        Assert.assertEquals((Object)"AAAd", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 29})));
        Assert.assertEquals((Object)"AAAe", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 30})));
        Assert.assertEquals((Object)"AAAf", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 31})));
        Assert.assertEquals((Object)"AAAg", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 32})));
        Assert.assertEquals((Object)"AAAh", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 33})));
        Assert.assertEquals((Object)"AAAi", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 34})));
        Assert.assertEquals((Object)"AAAj", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 35})));
        Assert.assertEquals((Object)"AAAk", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 36})));
        Assert.assertEquals((Object)"AAAl", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 37})));
        Assert.assertEquals((Object)"AAAm", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 38})));
        Assert.assertEquals((Object)"AAAn", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 39})));
        Assert.assertEquals((Object)"AAAo", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 40})));
        Assert.assertEquals((Object)"AAAp", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 41})));
        Assert.assertEquals((Object)"AAAq", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 42})));
        Assert.assertEquals((Object)"AAAr", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 43})));
        Assert.assertEquals((Object)"AAAs", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 44})));
        Assert.assertEquals((Object)"AAAt", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 45})));
        Assert.assertEquals((Object)"AAAu", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 46})));
        Assert.assertEquals((Object)"AAAv", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 47})));
        Assert.assertEquals((Object)"AAAw", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 48})));
        Assert.assertEquals((Object)"AAAx", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 49})));
        Assert.assertEquals((Object)"AAAy", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 50})));
        Assert.assertEquals((Object)"AAAz", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 51})));
        Assert.assertEquals((Object)"AAA0", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 52})));
        Assert.assertEquals((Object)"AAA1", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 53})));
        Assert.assertEquals((Object)"AAA2", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 54})));
        Assert.assertEquals((Object)"AAA3", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 55})));
        Assert.assertEquals((Object)"AAA4", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 56})));
        Assert.assertEquals((Object)"AAA5", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 57})));
        Assert.assertEquals((Object)"AAA6", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 58})));
        Assert.assertEquals((Object)"AAA7", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 59})));
        Assert.assertEquals((Object)"AAA8", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 60})));
        Assert.assertEquals((Object)"AAA9", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 61})));
        Assert.assertEquals((Object)"AAA+", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 62})));
        Assert.assertEquals((Object)"AAA/", (Object)new String(Base64Codec.encodeBase64(new byte[]{0, 0, 63})));
    }

    @Test
    public void testTripletsChunked() {
        Assert.assertEquals((Object)"AAAA\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 0})));
        Assert.assertEquals((Object)"AAAB\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 1})));
        Assert.assertEquals((Object)"AAAC\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 2})));
        Assert.assertEquals((Object)"AAAD\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 3})));
        Assert.assertEquals((Object)"AAAE\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 4})));
        Assert.assertEquals((Object)"AAAF\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 5})));
        Assert.assertEquals((Object)"AAAG\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 6})));
        Assert.assertEquals((Object)"AAAH\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 7})));
        Assert.assertEquals((Object)"AAAI\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 8})));
        Assert.assertEquals((Object)"AAAJ\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 9})));
        Assert.assertEquals((Object)"AAAK\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 10})));
        Assert.assertEquals((Object)"AAAL\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 11})));
        Assert.assertEquals((Object)"AAAM\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 12})));
        Assert.assertEquals((Object)"AAAN\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 13})));
        Assert.assertEquals((Object)"AAAO\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 14})));
        Assert.assertEquals((Object)"AAAP\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 15})));
        Assert.assertEquals((Object)"AAAQ\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 16})));
        Assert.assertEquals((Object)"AAAR\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 17})));
        Assert.assertEquals((Object)"AAAS\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 18})));
        Assert.assertEquals((Object)"AAAT\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 19})));
        Assert.assertEquals((Object)"AAAU\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 20})));
        Assert.assertEquals((Object)"AAAV\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 21})));
        Assert.assertEquals((Object)"AAAW\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 22})));
        Assert.assertEquals((Object)"AAAX\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 23})));
        Assert.assertEquals((Object)"AAAY\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 24})));
        Assert.assertEquals((Object)"AAAZ\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 25})));
        Assert.assertEquals((Object)"AAAa\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 26})));
        Assert.assertEquals((Object)"AAAb\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 27})));
        Assert.assertEquals((Object)"AAAc\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 28})));
        Assert.assertEquals((Object)"AAAd\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 29})));
        Assert.assertEquals((Object)"AAAe\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 30})));
        Assert.assertEquals((Object)"AAAf\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 31})));
        Assert.assertEquals((Object)"AAAg\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 32})));
        Assert.assertEquals((Object)"AAAh\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 33})));
        Assert.assertEquals((Object)"AAAi\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 34})));
        Assert.assertEquals((Object)"AAAj\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 35})));
        Assert.assertEquals((Object)"AAAk\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 36})));
        Assert.assertEquals((Object)"AAAl\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 37})));
        Assert.assertEquals((Object)"AAAm\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 38})));
        Assert.assertEquals((Object)"AAAn\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 39})));
        Assert.assertEquals((Object)"AAAo\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 40})));
        Assert.assertEquals((Object)"AAAp\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 41})));
        Assert.assertEquals((Object)"AAAq\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 42})));
        Assert.assertEquals((Object)"AAAr\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 43})));
        Assert.assertEquals((Object)"AAAs\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 44})));
        Assert.assertEquals((Object)"AAAt\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 45})));
        Assert.assertEquals((Object)"AAAu\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 46})));
        Assert.assertEquals((Object)"AAAv\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 47})));
        Assert.assertEquals((Object)"AAAw\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 48})));
        Assert.assertEquals((Object)"AAAx\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 49})));
        Assert.assertEquals((Object)"AAAy\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 50})));
        Assert.assertEquals((Object)"AAAz\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 51})));
        Assert.assertEquals((Object)"AAA0\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 52})));
        Assert.assertEquals((Object)"AAA1\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 53})));
        Assert.assertEquals((Object)"AAA2\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 54})));
        Assert.assertEquals((Object)"AAA3\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 55})));
        Assert.assertEquals((Object)"AAA4\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 56})));
        Assert.assertEquals((Object)"AAA5\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 57})));
        Assert.assertEquals((Object)"AAA6\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 58})));
        Assert.assertEquals((Object)"AAA7\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 59})));
        Assert.assertEquals((Object)"AAA8\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 60})));
        Assert.assertEquals((Object)"AAA9\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 61})));
        Assert.assertEquals((Object)"AAA+\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 62})));
        Assert.assertEquals((Object)"AAA/\r\n", (Object)new String(Base64Codec.encodeBase64Chunked(new byte[]{0, 0, 63})));
    }

    @Test
    public void testKnownEncodings() {
        Assert.assertEquals((Object)"VGhlIHF1aWNrIGJyb3duIGZveCBqdW1wZWQgb3ZlciB0aGUgbGF6eSBkb2dzLg==", (Object)new String(Base64Codec.encodeBase64("The quick brown fox jumped over the lazy dogs.".getBytes())));
        Assert.assertEquals((Object)"YmxhaCBibGFoIGJsYWggYmxhaCBibGFoIGJsYWggYmxhaCBibGFoIGJsYWggYmxhaCBibGFoIGJs\r\nYWggYmxhaCBibGFoIGJsYWggYmxhaCBibGFoIGJsYWggYmxhaCBibGFoIGJsYWggYmxhaCBibGFo\r\nIGJsYWggYmxhaCBibGFoIGJsYWggYmxhaCBibGFoIGJsYWggYmxhaCBibGFoIGJsYWggYmxhaCBi\r\nbGFoIGJsYWg=\r\n", (Object)new String(Base64Codec.encodeBase64Chunked("blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah blah".getBytes())));
        Assert.assertEquals((Object)"SXQgd2FzIHRoZSBiZXN0IG9mIHRpbWVzLCBpdCB3YXMgdGhlIHdvcnN0IG9mIHRpbWVzLg==", (Object)new String(Base64Codec.encodeBase64("It was the best of times, it was the worst of times.".getBytes())));
        Assert.assertEquals((Object)"aHR0cDovL2pha2FydGEuYXBhY2hlLm9yZy9jb21tbW9ucw==", (Object)new String(Base64Codec.encodeBase64("http://jakarta.apache.org/commmons".getBytes())));
        Assert.assertEquals((Object)"QWFCYkNjRGRFZUZmR2dIaElpSmpLa0xsTW1Obk9vUHBRcVJyU3NUdFV1VnZXd1h4WXlaeg==", (Object)new String(Base64Codec.encodeBase64("AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz".getBytes())));
        Assert.assertEquals((Object)"eyAwLCAxLCAyLCAzLCA0LCA1LCA2LCA3LCA4LCA5IH0=", (Object)new String(Base64Codec.encodeBase64("{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 }".getBytes())));
        Assert.assertEquals((Object)"eHl6enkh", (Object)new String(Base64Codec.encodeBase64("xyzzy!".getBytes())));
    }

    @Test
    public void testKnownDecodings() {
        Assert.assertEquals((Object)"The quick brown fox jumped over the lazy dogs.", (Object)new String(Base64Codec.decodeBase64("VGhlIHF1aWNrIGJyb3duIGZveCBqdW1wZWQgb3ZlciB0aGUgbGF6eSBkb2dzLg==".getBytes())));
        Assert.assertEquals((Object)"It was the best of times, it was the worst of times.", (Object)new String(Base64Codec.decodeBase64("SXQgd2FzIHRoZSBiZXN0IG9mIHRpbWVzLCBpdCB3YXMgdGhlIHdvcnN0IG9mIHRpbWVzLg==".getBytes())));
        Assert.assertEquals((Object)"http://jakarta.apache.org/commmons", (Object)new String(Base64Codec.decodeBase64("aHR0cDovL2pha2FydGEuYXBhY2hlLm9yZy9jb21tbW9ucw==".getBytes())));
        Assert.assertEquals((Object)"AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz", (Object)new String(Base64Codec.decodeBase64("QWFCYkNjRGRFZUZmR2dIaElpSmpLa0xsTW1Obk9vUHBRcVJyU3NUdFV1VnZXd1h4WXlaeg==".getBytes())));
        Assert.assertEquals((Object)"{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 }", (Object)new String(Base64Codec.decodeBase64("eyAwLCAxLCAyLCAzLCA0LCA1LCA2LCA3LCA4LCA5IH0=".getBytes())));
        Assert.assertEquals((Object)"xyzzy!", (Object)new String(Base64Codec.decodeBase64("eHl6enkh".getBytes())));
    }

    @Test
    public void testIgnoringNonBase64InDecode() throws Exception {
        Assert.assertEquals((Object)"The quick brown fox jumped over the lazy dogs.", (Object)new String(Base64Codec.decodeBase64("VGhlIH@$#$@%F1aWN@#@#@@rIGJyb3duIGZve\n\r\t%#%#%#%CBqd##$#$W1wZWQgb3ZlciB0aGUgbGF6eSBkb2dzLg==".getBytes())));
    }

    @Test
    public void testDecodeWithWhitespace() throws Exception {
        String orig = "I am a late night coder.";
        byte[] encodedArray = Base64Codec.encodeBase64(orig.getBytes());
        StringBuffer intermediate = new StringBuffer(new String(encodedArray));
        intermediate.insert(2, ' ');
        intermediate.insert(5, '\t');
        intermediate.insert(10, '\r');
        intermediate.insert(15, '\n');
        byte[] encodedWithWS = intermediate.toString().getBytes();
        byte[] decodedWithWS = Base64Codec.decodeBase64(encodedWithWS);
        String dest = new String(decodedWithWS);
        Assert.assertTrue((String)"Dest string doesn't equals the original", (boolean)dest.equals(orig));
    }

    @Test
    public void testDiscardWhitespace() throws Exception {
        String orig = "I am a late night coder.";
        byte[] encodedArray = Base64Codec.encodeBase64(orig.getBytes());
        StringBuffer intermediate = new StringBuffer(new String(encodedArray));
        intermediate.insert(2, ' ');
        intermediate.insert(5, '\t');
        intermediate.insert(10, '\r');
        intermediate.insert(15, '\n');
        byte[] encodedWithWS = intermediate.toString().getBytes();
        byte[] encodedNoWS = Base64Codec.discardWhitespace(encodedWithWS);
        byte[] decodedWithWS = Base64Codec.decodeBase64(encodedWithWS);
        byte[] decodedNoWS = Base64Codec.decodeBase64(encodedNoWS);
        String destFromWS = new String(decodedWithWS);
        String destFromNoWS = new String(decodedNoWS);
        Assert.assertTrue((String)"Dest string doesn't eausl original", (boolean)destFromWS.equals(orig));
        Assert.assertTrue((String)"Dest string doesn't eausl original", (boolean)destFromNoWS.equals(orig));
    }

    private String toString(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            buf.append(data[i]);
            if (i == data.length - 1) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    public Random getRandom() {
        return this._random;
    }
}

