/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.unit.UnitDbAdapter;

public class SybaseUnitDbAdapter
extends UnitDbAdapter {
    public SybaseUnitDbAdapter(DbAdapter adapter) {
        super(adapter);
    }

    @Override
    public String getIdentifiersStartQuote() {
        return "[";
    }

    @Override
    public String getIdentifiersEndQuote() {
        return "]";
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public void createdTables(Connection con, DataMap map) throws Exception {
        Procedure proc = map.getProcedure("cayenne_tst_select_proc");
        if (proc != null && proc.getDataMap() == map) {
            this.executeDDL(con, "sybase", "create-select-sp.sql");
            this.executeDDL(con, "sybase", "create-update-sp.sql");
            this.executeDDL(con, "sybase", "create-update-sp2.sql");
            this.executeDDL(con, "sybase", "create-out-sp.sql");
        }
    }

    @Override
    public void willCreateTables(Connection con, DataMap map) throws Exception {
        DbEntity e6;
        DbEntity e5;
        DbEntity e4;
        DbEntity e3;
        DbEntity e2;
        DbEntity e1;
        DbEntity e = map.getDbEntity("PRIMITIVES_TEST");
        if (e != null) {
            e.getAttribute("BOOLEAN_COLUMN").setMandatory(true);
        }
        if ((e1 = map.getDbEntity("INHERITANCE_SUB_ENTITY3")) != null) {
            e1.getAttribute("SUBENTITY_BOOL_ATTR").setMandatory(true);
        }
        if ((e2 = map.getDbEntity("MT_TABLE_BOOL")) != null) {
            e2.getAttribute("BOOLEAN_COLUMN").setMandatory(true);
        }
        if ((e3 = map.getDbEntity("QUALIFIED1")) != null) {
            e3.getAttribute("DELETED").setMandatory(true);
        }
        if ((e4 = map.getDbEntity("QUALIFIED2")) != null) {
            e4.getAttribute("DELETED").setMandatory(true);
        }
        if ((e5 = map.getDbEntity("Painting")) != null && e5.getAttribute("NEWCOL2") != null) {
            e5.getAttribute("DELETED").setMandatory(true);
        }
        if ((e6 = map.getDbEntity("SOFT_TEST")) != null) {
            e6.getAttribute("DELETED").setMandatory(true);
        }
    }

    public void willDropTables(Connection con, DataMap map, Collection tablesToDrop) throws Exception {
        Iterator it = tablesToDrop.iterator();
        while (it.hasNext()) {
            this.dropConstraints(con, (String)it.next());
        }
        this.dropProcedures(con, map);
    }

    protected void dropProcedures(Connection con, DataMap map) throws Exception {
        Procedure proc = map.getProcedure("cayenne_tst_select_proc");
        if (proc != null && proc.getDataMap() == map) {
            this.executeDDL(con, "sybase", "drop-select-sp.sql");
            this.executeDDL(con, "sybase", "drop-update-sp.sql");
            this.executeDDL(con, "sybase", "drop-update-sp2.sql");
            this.executeDDL(con, "sybase", "drop-out-sp.sql");
        }
    }

    protected void dropConstraints(Connection con, String tableName) throws Exception {
        ArrayList<String> names = new ArrayList<String>(3);
        try (Statement select = con.createStatement();
             ResultSet rs = select.executeQuery("SELECT t0.name FROM sysobjects t0, sysconstraints t1, sysobjects t2 WHERE t0.id = t1.constrid and t1.tableid = t2.id and t2.name = '" + tableName + "'");){
            while (rs.next()) {
                names.add(rs.getString("name"));
            }
        }
        for (String name : names) {
            this.executeDDL(con, "alter table " + tableName + " drop constraint " + name);
        }
    }

    @Override
    public boolean supportsLobs() {
        return true;
    }

    @Override
    public boolean handlesNullVsEmptyLOBs() {
        return false;
    }

    @Override
    public boolean supportsNullBoolean() {
        return false;
    }
}

