/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.util.TstBean;
import org.junit.Assert;
import org.junit.Test;

public class OrderingTest {
    @Test
    public void testPathSpec1() throws Exception {
        String pathSpec = "a.b.c";
        Ordering ord = new Ordering();
        Assert.assertNull((Object)ord.getSortSpec());
        ord.setSortSpecString(pathSpec);
        Assert.assertEquals((Object)pathSpec, (Object)ord.getSortSpec().getOperand(0));
    }

    @Test
    public void testPathSpec3() throws Exception {
        String pathSpec = "a.b.c";
        Ordering ord = new Ordering(pathSpec, SortOrder.DESCENDING);
        Assert.assertEquals((Object)pathSpec, (Object)ord.getSortSpec().getOperand(0));
    }

    @Test
    public void testAscending1() throws Exception {
        Ordering ord = new Ordering();
        ord.setAscending();
        Assert.assertTrue((boolean)ord.isAscending());
        Assert.assertFalse((boolean)ord.isDescending());
    }

    @Test
    public void testAscending2() throws Exception {
        Ordering ord = new Ordering();
        ord.setSortOrder(SortOrder.ASCENDING);
        Assert.assertTrue((boolean)ord.isAscending());
        Assert.assertFalse((boolean)ord.isDescending());
    }

    @Test
    public void testAscending3() throws Exception {
        Ordering ord = new Ordering();
        ord.setSortOrder(SortOrder.ASCENDING_INSENSITIVE);
        Assert.assertTrue((boolean)ord.isAscending());
        Assert.assertFalse((boolean)ord.isDescending());
    }

    @Test
    public void testDescending1() throws Exception {
        Ordering ord = new Ordering();
        ord.setDescending();
        Assert.assertFalse((boolean)ord.isAscending());
        Assert.assertTrue((boolean)ord.isDescending());
    }

    @Test
    public void testDescending2() throws Exception {
        Ordering ord = new Ordering();
        ord.setSortOrder(SortOrder.DESCENDING);
        Assert.assertFalse((boolean)ord.isAscending());
        Assert.assertTrue((boolean)ord.isDescending());
    }

    @Test
    public void testDescending3() throws Exception {
        Ordering ord = new Ordering();
        ord.setSortOrder(SortOrder.DESCENDING_INSENSITIVE);
        Assert.assertFalse((boolean)ord.isAscending());
        Assert.assertTrue((boolean)ord.isDescending());
    }

    @Test
    public void testCaseInsensitive3() throws Exception {
        Ordering ord = new Ordering("M", SortOrder.ASCENDING_INSENSITIVE);
        Assert.assertTrue((boolean)ord.isCaseInsensitive());
    }

    @Test
    public void testCaseInsensitive4() throws Exception {
        Ordering ord = new Ordering("N", SortOrder.ASCENDING);
        Assert.assertFalse((boolean)ord.isCaseInsensitive());
    }

    @Test
    public void testCaseInsensitive5() throws Exception {
        Ordering ord = new Ordering("M", SortOrder.DESCENDING_INSENSITIVE);
        Assert.assertTrue((boolean)ord.isCaseInsensitive());
    }

    @Test
    public void testCaseInsensitive6() throws Exception {
        Ordering ord = new Ordering("N", SortOrder.DESCENDING);
        Assert.assertFalse((boolean)ord.isCaseInsensitive());
    }

    @Test
    public void testCompare3() throws Exception {
        Painting p1 = new Painting();
        p1.setEstimatedPrice(new BigDecimal(1000.0));
        Painting p2 = new Painting();
        p2.setEstimatedPrice(new BigDecimal(2000.0));
        Painting p3 = new Painting();
        p3.setEstimatedPrice(new BigDecimal(2000.0));
        Ordering ordering = new Ordering("estimatedPrice", SortOrder.ASCENDING);
        Assert.assertTrue((ordering.compare(p1, p2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((ordering.compare(p2, p1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((ordering.compare(p2, p3) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompare4() throws Exception {
        TstBean t1 = new TstBean(1000);
        TstBean t2 = new TstBean(2000);
        TstBean t3 = new TstBean(2000);
        Ordering ordering = new Ordering("integer", SortOrder.ASCENDING);
        Assert.assertTrue((ordering.compare(t1, t2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((ordering.compare(t2, t1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((ordering.compare(t2, t3) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testOrderList2() throws Exception {
        ArrayList<TstBean> list = new ArrayList<TstBean>(3);
        list.add(new TstBean(5));
        list.add(new TstBean(2));
        list.add(new TstBean(3));
        new Ordering("integer", SortOrder.ASCENDING).orderList(list);
        Assert.assertEquals((long)2L, (long)((TstBean)list.get(0)).getInteger().intValue());
        Assert.assertEquals((long)3L, (long)((TstBean)list.get(1)).getInteger().intValue());
        Assert.assertEquals((long)5L, (long)((TstBean)list.get(2)).getInteger().intValue());
    }

    @Test
    public void testOrderListWithMultipleOrderings2() throws Exception {
        ArrayList<TstBean> list = new ArrayList<TstBean>(6);
        list.add(new TstBean("c", 1));
        list.add(new TstBean("c", 30));
        list.add(new TstBean("a", 5));
        list.add(new TstBean("b", 1));
        list.add(new TstBean("b", 2));
        list.add(new TstBean("b", 5));
        ArrayList<Ordering> orderings = new ArrayList<Ordering>(2);
        orderings.add(new Ordering("string", SortOrder.ASCENDING));
        orderings.add(new Ordering("integer", SortOrder.DESCENDING));
        ArrayList orderedList = new ArrayList(list);
        Ordering.orderList(orderedList, orderings);
        Assert.assertEquals(list.get(2), orderedList.get(0));
        Assert.assertEquals(list.get(5), orderedList.get(1));
        Assert.assertEquals(list.get(4), orderedList.get(2));
        Assert.assertEquals(list.get(3), orderedList.get(3));
        Assert.assertEquals(list.get(1), orderedList.get(4));
        Assert.assertEquals(list.get(0), orderedList.get(5));
    }

    @Test
    public void testOrderedListInstanceMethod() {
        HashSet<TstBean> set = new HashSet<TstBean>(6);
        TstBean shouldBe0 = new TstBean("a", 0);
        TstBean shouldBe1 = new TstBean("b", 0);
        TstBean shouldBe2 = new TstBean("c", 0);
        TstBean shouldBe3 = new TstBean("d", 0);
        TstBean shouldBe4 = new TstBean("f", 0);
        TstBean shouldBe5 = new TstBean("r", 0);
        set.add(shouldBe1);
        set.add(shouldBe0);
        set.add(shouldBe5);
        set.add(shouldBe3);
        set.add(shouldBe2);
        set.add(shouldBe4);
        List orderedList = new Ordering("string", SortOrder.ASCENDING).orderedList(set);
        Assert.assertEquals((Object)shouldBe0, orderedList.get(0));
        Assert.assertEquals((Object)shouldBe1, orderedList.get(1));
        Assert.assertEquals((Object)shouldBe2, orderedList.get(2));
        Assert.assertEquals((Object)shouldBe3, orderedList.get(3));
        Assert.assertEquals((Object)shouldBe4, orderedList.get(4));
        Assert.assertEquals((Object)shouldBe5, orderedList.get(5));
    }

    @Test
    public void testOrderedListStaticMethod() {
        HashSet<TstBean> set = new HashSet<TstBean>(6);
        TstBean shouldBe0 = new TstBean("a", 5);
        TstBean shouldBe1 = new TstBean("b", 5);
        TstBean shouldBe2 = new TstBean("b", 2);
        TstBean shouldBe3 = new TstBean("b", 1);
        TstBean shouldBe4 = new TstBean("c", 30);
        TstBean shouldBe5 = new TstBean("c", 1);
        set.add(shouldBe0);
        set.add(shouldBe5);
        set.add(shouldBe3);
        set.add(shouldBe1);
        set.add(shouldBe4);
        set.add(shouldBe2);
        ArrayList<Ordering> orderings = new ArrayList<Ordering>(2);
        orderings.add(new Ordering("string", SortOrder.ASCENDING));
        orderings.add(new Ordering("integer", SortOrder.DESCENDING));
        List orderedList = Ordering.orderedList(set, orderings);
        Assert.assertEquals((Object)shouldBe0, orderedList.get(0));
        Assert.assertEquals((Object)shouldBe1, orderedList.get(1));
        Assert.assertEquals((Object)shouldBe2, orderedList.get(2));
        Assert.assertEquals((Object)shouldBe3, orderedList.get(3));
        Assert.assertEquals((Object)shouldBe4, orderedList.get(4));
        Assert.assertEquals((Object)shouldBe5, orderedList.get(5));
    }
}

