/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Collections;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class EJBQLQueryCountIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tPainting;
    protected TableHelper tGallery;

    @Before
    public void before() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE"});
    }

    @Test
    public void test_ToOne() throws Exception {
        this.tArtist.insert(new Object[]{1, "A1"});
        this.tArtist.insert(new Object[]{2, "A2"});
        this.tArtist.insert(new Object[]{3, "A3"});
        this.tPainting.insert(new Object[]{1, 1, "P1"});
        this.tPainting.insert(new Object[]{2, 1, "P2"});
        this.tPainting.insert(new Object[]{4, 2, "P1"});
        EJBQLQuery query = new EJBQLQuery("SELECT COUNT(p.toArtist) FROM Painting p");
        Assert.assertEquals(Collections.singletonList(3L), (Object)this.context.performQuery(query));
    }

    @Test
    public void test_DistinctToOneAttribute() throws Exception {
        this.tArtist.insert(new Object[]{1, "A1"});
        this.tArtist.insert(new Object[]{2, "A1"});
        this.tArtist.insert(new Object[]{3, "A1"});
        this.tPainting.insert(new Object[]{1, 1, "P1"});
        this.tPainting.insert(new Object[]{2, 1, "P2"});
        this.tPainting.insert(new Object[]{4, 2, "P1"});
        EJBQLQuery query = new EJBQLQuery("SELECT COUNT(DISTINCT p.toArtist.artistName) FROM Painting p");
        Assert.assertEquals(Collections.singletonList(1L), (Object)this.context.performQuery(query));
    }
}

