/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.EventSubject;
import org.apache.cayenne.event.XMPPBridge;
import org.apache.cayenne.event.XMPPBridgeFactory;
import org.junit.Assert;
import org.junit.Test;

public class XMPPBridgeFactoryTest {
    @Test
    public void testCreateEventBridge() {
        XMPPBridgeFactory factory = new XMPPBridgeFactory();
        Set<EventSubject> subjects = Collections.singleton(EventSubject.getSubject(this.getClass(), "test"));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cayenne.XMPPBridge.xmppHost", "somehost.com");
        properties.put("cayenne.XMPPBridge.xmppPort", "12345");
        EventBridge bridge = factory.createEventBridge(subjects, "remote-subject", properties);
        Assert.assertTrue((boolean)(bridge instanceof XMPPBridge));
        XMPPBridge xmppBridge = (XMPPBridge)bridge;
        Assert.assertEquals(subjects, xmppBridge.getLocalSubjects());
        Assert.assertEquals((Object)"remote-subject", (Object)xmppBridge.getExternalSubject());
        Assert.assertEquals((Object)"somehost.com", (Object)xmppBridge.getXmppHost());
        Assert.assertEquals((long)12345L, (long)xmppBridge.getXmppPort());
    }
}

