/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbimport;

import java.util.Collection;
import java.util.LinkedList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.apache.cayenne.dbimport.ExcludeColumn;
import org.apache.cayenne.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbimport.ExcludeTable;
import org.apache.cayenne.dbimport.IncludeColumn;
import org.apache.cayenne.dbimport.IncludeProcedure;
import org.apache.cayenne.dbimport.IncludeTable;
import org.apache.cayenne.dbimport.PatternParam;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class FilterContainer {
    @XmlElement(name="includeTable")
    private Collection<IncludeTable> includeTables = new LinkedList<IncludeTable>();
    @XmlElement(name="excludeTable")
    private Collection<ExcludeTable> excludeTables = new LinkedList<ExcludeTable>();
    @XmlElement(name="includeColumn")
    private Collection<IncludeColumn> includeColumns = new LinkedList<IncludeColumn>();
    @XmlElement(name="excludeColumn")
    private Collection<ExcludeColumn> excludeColumns = new LinkedList<ExcludeColumn>();
    @XmlElement(name="includeProcedure")
    private Collection<IncludeProcedure> includeProcedures = new LinkedList<IncludeProcedure>();
    @XmlElement(name="excludeProcedure")
    private Collection<ExcludeProcedure> excludeProcedures = new LinkedList<ExcludeProcedure>();

    public Collection<IncludeTable> getIncludeTables() {
        return this.includeTables;
    }

    public void setIncludeTables(Collection<IncludeTable> includeTables) {
        this.includeTables = includeTables;
    }

    public Collection<ExcludeTable> getExcludeTables() {
        return this.excludeTables;
    }

    public void setExcludeTables(Collection<ExcludeTable> excludeTables) {
        this.excludeTables = excludeTables;
    }

    public Collection<IncludeColumn> getIncludeColumns() {
        return this.includeColumns;
    }

    public void setIncludeColumns(Collection<IncludeColumn> includeColumns) {
        this.includeColumns = includeColumns;
    }

    public Collection<ExcludeColumn> getExcludeColumns() {
        return this.excludeColumns;
    }

    public void setExcludeColumns(Collection<ExcludeColumn> excludeColumns) {
        this.excludeColumns = excludeColumns;
    }

    public Collection<IncludeProcedure> getIncludeProcedures() {
        return this.includeProcedures;
    }

    public void setIncludeProcedures(Collection<IncludeProcedure> includeProcedures) {
        this.includeProcedures = includeProcedures;
    }

    public Collection<ExcludeProcedure> getExcludeProcedures() {
        return this.excludeProcedures;
    }

    public void setExcludeProcedures(Collection<ExcludeProcedure> excludeProcedures) {
        this.excludeProcedures = excludeProcedures;
    }

    public void addIncludeColumn(IncludeColumn includeColumn) {
        this.includeColumns.add(includeColumn);
    }

    public void addExcludeColumn(ExcludeColumn excludeColumn) {
        this.excludeColumns.add(excludeColumn);
    }

    public void addIncludeTable(IncludeTable includeTable) {
        this.includeTables.add(includeTable);
    }

    public void addExcludeTable(ExcludeTable excludeTable) {
        this.excludeTables.add(excludeTable);
    }

    public void addIncludeProcedure(IncludeProcedure includeProcedure) {
        this.includeProcedures.add(includeProcedure);
    }

    public void addExcludeProcedure(ExcludeProcedure excludeProcedure) {
        this.excludeProcedures.add(excludeProcedure);
    }

    public boolean isEmptyContainer() {
        return this.includeColumns.isEmpty() && this.excludeColumns.isEmpty() && this.includeTables.isEmpty() && this.excludeTables.isEmpty() && this.includeProcedures.isEmpty() && this.excludeProcedures.isEmpty();
    }

    public static boolean isBlank(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public String toString() {
        return this.toString(new StringBuilder(), "").toString();
    }

    public StringBuilder toString(StringBuilder res, String prefix) {
        this.appendCollection(res, prefix, this.includeTables);
        this.appendCollection(res, prefix, this.excludeTables);
        this.appendCollection(res, prefix, this.includeColumns);
        this.appendCollection(res, prefix, this.excludeColumns);
        this.appendCollection(res, prefix, this.includeProcedures);
        this.appendCollection(res, prefix, this.excludeProcedures);
        return res;
    }

    protected void appendCollection(StringBuilder res, String prefix, Collection<? extends PatternParam> collection) {
        if (!FilterContainer.isBlank(collection)) {
            for (PatternParam patternParam : collection) {
                patternParam.toString(res, prefix);
            }
        }
    }
}

