/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbimport;

import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.cayenne.dbimport.Catalog;
import org.apache.cayenne.dbimport.DefaultReverseEngineeringWriter;
import org.apache.cayenne.dbimport.ExcludeColumn;
import org.apache.cayenne.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbimport.ExcludeTable;
import org.apache.cayenne.dbimport.IncludeColumn;
import org.apache.cayenne.dbimport.IncludeProcedure;
import org.apache.cayenne.dbimport.IncludeTable;
import org.apache.cayenne.dbimport.ReverseEngineering;
import org.apache.cayenne.dbimport.Schema;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.URLResource;
import org.custommonkey.xmlunit.Diff;
import org.junit.Assert;
import org.junit.Test;

public class DefaultReverseEngineeringWriterTest {
    @Test
    public void testWriteReverseEngineering() throws Exception {
        DefaultReverseEngineeringWriter engineering = new DefaultReverseEngineeringWriter();
        ReverseEngineering reverseEngineering = new ReverseEngineering();
        Catalog catalog1 = new Catalog("catalog1");
        Catalog catalog2 = new Catalog("catalog2");
        Catalog catalog3 = new Catalog("catalog3");
        catalog1.addSchema(new Schema("schema1"));
        catalog1.addSchema(new Schema("schema2"));
        catalog1.addExcludeColumn(new ExcludeColumn("excludedColumn1"));
        catalog1.addExcludeColumn(new ExcludeColumn("excludedColumn2"));
        catalog1.addIncludeColumn(new IncludeColumn("includedColumn1"));
        catalog1.addIncludeColumn(new IncludeColumn("includedColumn2"));
        catalog1.addExcludeProcedure(new ExcludeProcedure("excludedProcedure1"));
        catalog1.addExcludeProcedure(new ExcludeProcedure("excludedProcedure2"));
        catalog1.addIncludeProcedure(new IncludeProcedure("includedProcedure1"));
        catalog1.addIncludeProcedure(new IncludeProcedure("includedProcedure2"));
        catalog1.addExcludeTable(new ExcludeTable("excludedTable1"));
        catalog1.addExcludeTable(new ExcludeTable("excludedTable2"));
        catalog1.addIncludeTable(new IncludeTable("includedTable1"));
        catalog1.addIncludeTable(new IncludeTable("includedTable2"));
        reverseEngineering.addCatalog(catalog1);
        reverseEngineering.addCatalog(catalog2);
        reverseEngineering.addCatalog(catalog3);
        reverseEngineering.addSchema(new Schema("schema3"));
        URL url = this.getClass().getResource("reverseEngineering.xml");
        String decodedURL = URLDecoder.decode(url.getPath(), "UTF-8");
        PrintWriter printWriter = new PrintWriter(decodedURL);
        reverseEngineering.setConfigurationSource(new URLResource(url));
        Resource reverseEngineeringResource = engineering.write(reverseEngineering, printWriter);
        this.assertReverseEngineering(reverseEngineeringResource);
    }

    public void assertReverseEngineering(Resource resource) throws Exception {
        URL url1 = resource.getURL();
        URL url2 = this.getResource("reverseEngineering-expected.xml").getURL();
        FileReader writedXML = new FileReader(URLDecoder.decode(url1.getPath(), "UTF-8"));
        FileReader expectedXML = new FileReader(URLDecoder.decode(url2.getPath(), "UTF-8"));
        Diff diff = new Diff((Reader)writedXML, (Reader)expectedXML);
        Assert.assertTrue((boolean)diff.identical());
    }

    protected URLResource getResource(String file) throws MalformedURLException {
        return new URLResource(this.getClass().getResource(file));
    }
}

