/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.util.ArrayList;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.access.translator.select.TrimmingQualifierTranslator;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTIn;
import org.apache.cayenne.exp.parser.ASTList;
import org.apache.cayenne.exp.parser.ASTNegate;
import org.apache.cayenne.exp.parser.ASTNotIn;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.commons.collections.Transformer;

public class OracleQualifierTranslator
extends TrimmingQualifierTranslator {
    public OracleQualifierTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler, "RTRIM");
    }

    @Override
    protected void doAppendPart(Expression rootNode) {
        if (rootNode == null) {
            return;
        }
        rootNode = rootNode.transform(new INTrimmer());
        rootNode.traverse(this);
    }

    public static class INTrimmer
    implements Transformer {
        public Expression trimmedInExpression(Expression exp, int maxInSize) {
            Expression list = (Expression)exp.getOperand(1);
            Object[] objects = (Object[])list.evaluate(null);
            if (objects.length <= maxInSize) {
                return exp;
            }
            Expression trimmed = this.trimmedInExpression((ASTPath)exp.getOperand(0), objects, maxInSize);
            if (exp instanceof ASTNotIn) {
                return new ASTNegate(trimmed);
            }
            return trimmed;
        }

        Expression trimmedInExpression(ASTPath path, Object[] values, int maxInSize) {
            ASTIn res = null;
            ArrayList<Object> in = new ArrayList<Object>(maxInSize);
            for (Object v : values) {
                in.add(v);
                if (in.size() != maxInSize) continue;
                ASTIn inExp = new ASTIn(path, new ASTList(in));
                res = res != null ? res.orExp(inExp) : inExp;
                in = new ArrayList(maxInSize);
            }
            if (in.size() > 0) {
                ASTIn inExp = new ASTIn(path, new ASTList(in));
                res = res != null ? res.orExp(inExp) : inExp;
            }
            return res;
        }

        public Object transform(Object input) {
            if (input instanceof ASTIn || input instanceof ASTNotIn) {
                return this.trimmedInExpression((Expression)input, 1000);
            }
            return input;
        }
    }
}

