/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.datasource;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.cayenne.datasource.PoolAwareConnection;
import org.apache.cayenne.datasource.UnmanagedPoolingDataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PoolAwareConnectionTest {
    private UnmanagedPoolingDataSource parentMock;
    private Connection connectionMock;

    @Before
    public void before() throws SQLException {
        this.connectionMock = (Connection)Mockito.mock(Connection.class);
        this.parentMock = (UnmanagedPoolingDataSource)Mockito.mock(UnmanagedPoolingDataSource.class);
        Mockito.when((Object)this.parentMock.createUnwrapped()).thenReturn((Object)this.connectionMock);
    }

    @Test
    public void testRecover() throws SQLException {
        PoolAwareConnection paConnection = new PoolAwareConnection(this.parentMock, this.connectionMock, null);
        SQLException e = (SQLException)Mockito.mock(SQLException.class);
        ((UnmanagedPoolingDataSource)Mockito.verify((Object)this.parentMock, (VerificationMode)Mockito.times((int)0))).createUnwrapped();
        paConnection.recover(e);
        ((UnmanagedPoolingDataSource)Mockito.verify((Object)this.parentMock, (VerificationMode)Mockito.times((int)1))).createUnwrapped();
        Assert.assertSame((Object)this.connectionMock, (Object)paConnection.getConnection());
    }

    @Test
    public void testPrepareStatement() throws SQLException {
        PreparedStatement firstTry = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        PreparedStatement secondTry = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)this.connectionMock.prepareStatement(Matchers.anyString())).thenReturn((Object)firstTry, (Object[])new PreparedStatement[]{secondTry});
        PoolAwareConnection paConnection = new PoolAwareConnection(this.parentMock, this.connectionMock, null);
        PreparedStatement st = paConnection.prepareStatement("SELECT 1");
        Assert.assertSame((Object)firstTry, (Object)st);
    }

    @Test
    public void testPrepareStatement_Recover() throws SQLException {
        PreparedStatement secondTry = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)this.connectionMock.prepareStatement(Matchers.anyString())).thenThrow(new Throwable[]{new SQLException("E1")}).thenReturn((Object)secondTry);
        PoolAwareConnection paConnection = new PoolAwareConnection(this.parentMock, this.connectionMock, null);
        PreparedStatement st = paConnection.prepareStatement("SELECT 1");
        Assert.assertSame((Object)secondTry, (Object)st);
    }

    @Test
    public void testPrepareStatement_Recover_Impossible() throws SQLException {
        SQLException original = new SQLException("E1");
        Mockito.when((Object)this.connectionMock.prepareStatement(Matchers.anyString())).thenThrow(new Throwable[]{original});
        PoolAwareConnection paConnection = new PoolAwareConnection(this.parentMock, this.connectionMock, null);
        try {
            paConnection.prepareStatement("SELECT 1");
        }
        catch (SQLException e) {
            Assert.assertSame((Object)original, (Object)e);
        }
    }
}

