/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.web;

import com.mockrunner.mock.web.MockFilterChain;
import com.mockrunner.mock.web.MockFilterConfig;
import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpServletResponse;
import com.mockrunner.mock.web.MockServletContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.cayenne.configuration.CayenneRuntime;
import org.apache.cayenne.configuration.ModuleCollection;
import org.apache.cayenne.configuration.server.ServerModule;
import org.apache.cayenne.configuration.web.CayenneFilter;
import org.apache.cayenne.configuration.web.CayenneFilter_DispatchModule;
import org.apache.cayenne.configuration.web.CayenneFilter_DispatchRequestHandler;
import org.apache.cayenne.configuration.web.MockModule1;
import org.apache.cayenne.configuration.web.MockModule2;
import org.apache.cayenne.configuration.web.MockRequestHandler;
import org.apache.cayenne.configuration.web.RequestHandler;
import org.apache.cayenne.configuration.web.SessionContextRequestHandler;
import org.apache.cayenne.configuration.web.WebModule;
import org.apache.cayenne.configuration.web.WebUtil;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Module;
import org.junit.Assert;
import org.junit.Test;

public class CayenneFilterTest {
    @Test
    public void testInitWithFilterName() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setFilterName("abc");
        MockServletContext context = new MockServletContext();
        config.setupServletContext((ServletContext)context);
        CayenneFilter filter = new CayenneFilter();
        Assert.assertNull((Object)WebUtil.getCayenneRuntime((ServletContext)context));
        filter.init((FilterConfig)config);
        CayenneRuntime runtime = WebUtil.getCayenneRuntime((ServletContext)context);
        Assert.assertNotNull((Object)runtime);
        List locations = (List)runtime.getInjector().getInstance(Key.get(List.class, (String)"cayenne.server.project_locations"));
        Assert.assertEquals(Arrays.asList("abc.xml"), (Object)locations);
    }

    @Test
    public void testInitWithLocation() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setFilterName("abc");
        config.setInitParameter("configuration-location", "xyz");
        MockServletContext context = new MockServletContext();
        config.setupServletContext((ServletContext)context);
        CayenneFilter filter = new CayenneFilter();
        filter.init((FilterConfig)config);
        CayenneRuntime runtime = WebUtil.getCayenneRuntime((ServletContext)context);
        Assert.assertNotNull((Object)runtime);
        List locations = (List)runtime.getInjector().getInstance(Key.get(List.class, (String)"cayenne.server.project_locations"));
        Assert.assertEquals(Arrays.asList("xyz"), (Object)locations);
    }

    @Test
    public void testInitWithStandardModules() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setFilterName("cayenne-abc");
        MockServletContext context = new MockServletContext();
        config.setupServletContext((ServletContext)context);
        CayenneFilter filter = new CayenneFilter();
        Assert.assertNull((Object)WebUtil.getCayenneRuntime((ServletContext)context));
        filter.init((FilterConfig)config);
        CayenneRuntime runtime = WebUtil.getCayenneRuntime((ServletContext)context);
        Assert.assertNotNull((Object)runtime);
        List locations = (List)runtime.getInjector().getInstance(Key.get(List.class, (String)"cayenne.server.project_locations"));
        Assert.assertEquals(Arrays.asList("cayenne-abc.xml"), (Object)locations);
        Collection<Module> modules = ((ModuleCollection)runtime.getModule()).getModules();
        Assert.assertEquals((long)2L, (long)modules.size());
        Object[] marray = modules.toArray();
        Assert.assertTrue((boolean)(marray[0] instanceof ServerModule));
        Assert.assertTrue((boolean)(marray[1] instanceof WebModule));
        RequestHandler handler = (RequestHandler)runtime.getInjector().getInstance(RequestHandler.class);
        Assert.assertTrue((boolean)(handler instanceof SessionContextRequestHandler));
    }

    @Test
    public void testInitWithExtraModules() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setFilterName("abc");
        config.setInitParameter("extra-modules", MockModule1.class.getName() + "," + MockModule2.class.getName());
        MockServletContext context = new MockServletContext();
        config.setupServletContext((ServletContext)context);
        CayenneFilter filter = new CayenneFilter();
        filter.init((FilterConfig)config);
        CayenneRuntime runtime = WebUtil.getCayenneRuntime((ServletContext)context);
        Assert.assertNotNull((Object)runtime);
        Collection<Module> modules = ((ModuleCollection)runtime.getModule()).getModules();
        Assert.assertEquals((long)4L, (long)modules.size());
        Object[] marray = modules.toArray();
        Assert.assertTrue((boolean)(marray[0] instanceof ServerModule));
        Assert.assertTrue((boolean)(marray[1] instanceof WebModule));
        Assert.assertTrue((boolean)(marray[2] instanceof MockModule1));
        Assert.assertTrue((boolean)(marray[3] instanceof MockModule2));
        RequestHandler handler = (RequestHandler)runtime.getInjector().getInstance(RequestHandler.class);
        Assert.assertTrue((boolean)(handler instanceof MockRequestHandler));
    }

    @Test
    public void testDoFilter() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setFilterName("abc");
        config.setInitParameter("extra-modules", CayenneFilter_DispatchModule.class.getName());
        MockServletContext context = new MockServletContext();
        config.setupServletContext((ServletContext)context);
        CayenneFilter filter = new CayenneFilter();
        filter.init((FilterConfig)config);
        CayenneRuntime runtime = WebUtil.getCayenneRuntime((ServletContext)context);
        CayenneFilter_DispatchRequestHandler handler = (CayenneFilter_DispatchRequestHandler)runtime.getInjector().getInstance(RequestHandler.class);
        Assert.assertEquals((long)0L, (long)handler.getStarted());
        Assert.assertEquals((long)0L, (long)handler.getEnded());
        filter.doFilter((ServletRequest)new MockHttpServletRequest(), (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
        Assert.assertEquals((long)1L, (long)handler.getStarted());
        Assert.assertEquals((long)1L, (long)handler.getEnded());
        filter.doFilter((ServletRequest)new MockHttpServletRequest(), (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
        Assert.assertEquals((long)2L, (long)handler.getStarted());
        Assert.assertEquals((long)2L, (long)handler.getEnded());
    }
}

