/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.sql.Connection;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.tx.Transaction;
import org.apache.cayenne.tx.TransactionListener;
import org.apache.cayenne.tx.TransactionalOperation;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.validation.ValidationException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ServerRuntimeIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;

    @Test
    public void testPerformInTransaction_Local_Callback() {
        TransactionListener callback = (TransactionListener)Mockito.mock(TransactionListener.class);
        Artist a = this.runtime.performInTransaction(new TransactionalOperation<Artist>(){

            @Override
            public Artist perform() {
                Artist localArtist = ServerRuntimeIT.this.runtime.newContext().newObject(Artist.class);
                localArtist.setArtistName("A1");
                localArtist.getObjectContext().commitChanges();
                return localArtist;
            }
        }, callback);
        Assert.assertEquals((Object)"A1", (Object)a.getArtistName());
        Assert.assertEquals((long)3L, (long)a.getPersistenceState());
        ((TransactionListener)Mockito.verify((Object)callback)).willCommit((Transaction)Matchers.any(Transaction.class));
        ((TransactionListener)Mockito.verify((Object)callback)).willAddConnection((Transaction)Matchers.any(Transaction.class), (String)Matchers.any(String.class), (Connection)Matchers.any(Connection.class));
        ((TransactionListener)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)0))).willRollback((Transaction)Matchers.any(Transaction.class));
    }

    @Test
    public void testPerformInTransaction_Local_Callback_Rollback() {
        TransactionListener callback = (TransactionListener)Mockito.mock(TransactionListener.class);
        try {
            this.runtime.performInTransaction(new TransactionalOperation<Artist>(){

                @Override
                public Artist perform() {
                    Artist localArtist = ServerRuntimeIT.this.runtime.newContext().newObject(Artist.class);
                    localArtist.getObjectContext().commitChanges();
                    return localArtist;
                }
            }, callback);
            Assert.fail((String)"Exception expected");
        }
        catch (ValidationException v) {
            ((TransactionListener)Mockito.verify((Object)callback)).willRollback((Transaction)Matchers.any(Transaction.class));
            ((TransactionListener)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)0))).willAddConnection((Transaction)Matchers.any(Transaction.class), (String)Matchers.any(String.class), (Connection)Matchers.any(Connection.class));
            ((TransactionListener)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)0))).willCommit((Transaction)Matchers.any(Transaction.class));
        }
    }
}

