/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ashwood;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ashwood.AshwoodEntitySorter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.relationships.ReflexiveAndToOne;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-relationships.xml")
public class AshwoodEntitySorter_RelationshipsIT
extends ServerCase {
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected ObjectContext context;
    private TableHelper tRelationshipHelper;
    private TableHelper tReflexiveAndToOne;
    private AshwoodEntitySorter sorter;

    @Before
    public void setUp() throws Exception {
        this.sorter = new AshwoodEntitySorter();
        this.sorter.setEntityResolver(this.context.getEntityResolver());
        this.tRelationshipHelper = new TableHelper(this.dbHelper, "RELATIONSHIP_HELPER");
        this.tRelationshipHelper.setColumns(new String[]{"RELATIONSHIP_HELPER_ID", "NAME"});
        this.tReflexiveAndToOne = new TableHelper(this.dbHelper, "REFLEXIVE_AND_TO_ONE");
        this.tReflexiveAndToOne.setColumns(new String[]{"REFLEXIVE_AND_TO_ONE_ID", "PARENT_ID", "RELATIONSHIP_HELPER_ID", "NAME"}).setColumnTypes(new int[]{4, 4, 4, 12});
    }

    @Test
    public void testSortObjectsForEntityReflexiveWithFaults() throws Exception {
        this.tRelationshipHelper.insert(new Object[]{1, "rh1"});
        this.tReflexiveAndToOne.insert(new Object[]{1, null, 1, "r1"});
        this.tReflexiveAndToOne.insert(new Object[]{2, 1, 1, "r2"});
        this.tReflexiveAndToOne.insert(new Object[]{3, 2, 1, "r3"});
        ObjEntity entity = this.context.getEntityResolver().getObjEntity(ReflexiveAndToOne.class);
        List objects = this.context.performQuery(new SelectQuery<ReflexiveAndToOne>(ReflexiveAndToOne.class));
        Collections.shuffle(objects);
        Assert.assertEquals((long)3L, (long)objects.size());
        this.sorter.sortObjectsForEntity(entity, objects, true);
        Assert.assertEquals((Object)"r3", (Object)((ReflexiveAndToOne)objects.get(0)).getName());
        Assert.assertEquals((Object)"r2", (Object)((ReflexiveAndToOne)objects.get(1)).getName());
        Assert.assertEquals((Object)"r1", (Object)((ReflexiveAndToOne)objects.get(2)).getName());
    }
}

