/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.ExtendedType;

public class BooleanType
implements ExtendedType {
    @Override
    public String getClassName() {
        return Boolean.class.getName();
    }

    @Override
    public void setJdbcObject(PreparedStatement st, Object val, int pos, int type, int precision) throws Exception {
        if (val == null) {
            st.setNull(pos, type);
        } else if (type == -7 || type == 16) {
            boolean flag = Boolean.TRUE.equals(val);
            st.setBoolean(pos, flag);
        } else {
            st.setObject(pos, val, type);
        }
    }

    @Override
    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        boolean b = rs.getBoolean(index);
        return rs.wasNull() ? null : (b ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public Object materializeObject(CallableStatement st, int index, int type) throws Exception {
        boolean b = st.getBoolean(index);
        return st.wasNull() ? null : (b ? Boolean.TRUE : Boolean.FALSE);
    }
}

