/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.access.DbGenerator;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DbGeneratorIT
extends ServerCase {
    @Inject
    private DbAdapter adapter;
    @Inject
    private ServerRuntime runtime;
    @Inject
    private JdbcEventLogger logger;
    private DbGenerator generator;

    @Before
    public void setUp() throws Exception {
        this.generator = new DbGenerator(this.adapter, this.runtime.getDataDomain().getDataMap("testmap"), this.logger);
    }

    @Test
    public void testAdapter() throws Exception {
        Assert.assertSame((Object)this.adapter, (Object)this.generator.getAdapter());
    }

    @Test
    public void testPkFilteringLogic() throws Exception {
        DataMap map = this.runtime.getDataDomain().getDataMap("testmap");
        DbEntity artistExhibit = map.getDbEntity("ARTIST_EXHIBIT");
        DbEntity exhibit = map.getDbEntity("EXHIBIT");
        Assert.assertNotNull((Object)artistExhibit);
        Assert.assertNotNull((Object)exhibit);
        Assert.assertNotNull(this.generator.dbEntitiesRequiringAutoPK);
        Assert.assertTrue((boolean)this.generator.dbEntitiesRequiringAutoPK.contains(exhibit));
        Assert.assertFalse((boolean)this.generator.dbEntitiesRequiringAutoPK.contains(artistExhibit));
    }

    @Test
    public void testCreatePkSupport() throws Exception {
        Assert.assertTrue((boolean)this.generator.shouldCreatePKSupport());
        this.generator.setShouldCreatePKSupport(false);
        Assert.assertFalse((boolean)this.generator.shouldCreatePKSupport());
    }

    @Test
    public void testShouldCreateTables() throws Exception {
        Assert.assertTrue((boolean)this.generator.shouldCreateTables());
        this.generator.setShouldCreateTables(false);
        Assert.assertFalse((boolean)this.generator.shouldCreateTables());
    }

    @Test
    public void testDropPkSupport() throws Exception {
        Assert.assertFalse((boolean)this.generator.shouldDropPKSupport());
        this.generator.setShouldDropPKSupport(true);
        Assert.assertTrue((boolean)this.generator.shouldDropPKSupport());
    }

    @Test
    public void testShouldDropTables() throws Exception {
        Assert.assertFalse((boolean)this.generator.shouldDropTables());
        this.generator.setShouldDropTables(true);
        Assert.assertTrue((boolean)this.generator.shouldDropTables());
    }
}

