/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.RelationshipQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextRelationshipQueryIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tArtist;
    private TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID"});
    }

    private void createOneArtistOnePaintingDataSet() throws Exception {
        this.tArtist.insert(new Object[]{1, "a1"});
        this.tPainting.insert(new Object[]{1, "p1", 1});
    }

    @Test
    public void testUnrefreshingToOne() throws Exception {
        this.createOneArtistOnePaintingDataSet();
        Painting p = Cayenne.objectForPK((ObjectContext)this.context, Painting.class, 1);
        Artist a = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 1);
        long v = a.getSnapshotVersion();
        int writeCalls = a.getPropertyWrittenDirectly();
        Assert.assertEquals((Object)"a1", (Object)a.getArtistName());
        Assert.assertEquals((long)1L, (long)this.tArtist.update().set("ARTIST_NAME", (Object)"a2").where("ARTIST_ID", (Object)1).execute());
        RelationshipQuery toOne = new RelationshipQuery(p.getObjectId(), "toArtist", false);
        List related = this.context.performQuery(toOne);
        Assert.assertEquals((long)1L, (long)related.size());
        Assert.assertTrue((boolean)related.contains(a));
        Assert.assertEquals((Object)"a1", (Object)a.getArtistName());
        Assert.assertEquals((long)v, (long)a.getSnapshotVersion());
        Assert.assertEquals((String)"Looks like relationship query caused snapshot refresh", (long)writeCalls, (long)a.getPropertyWrittenDirectly());
    }

    @Test
    public void testRefreshingToOne() throws Exception {
        this.createOneArtistOnePaintingDataSet();
        Painting p = Cayenne.objectForPK((ObjectContext)this.context, Painting.class, 1);
        Artist a = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 1);
        long v = a.getSnapshotVersion();
        int writeCalls = a.getPropertyWrittenDirectly();
        Assert.assertEquals((Object)"a1", (Object)a.getArtistName());
        Assert.assertEquals((long)1L, (long)this.tArtist.update().set("ARTIST_NAME", (Object)"a2").where("ARTIST_ID", (Object)1).execute());
        RelationshipQuery toOne = new RelationshipQuery(p.getObjectId(), "toArtist", true);
        List related = this.context.performQuery(toOne);
        Assert.assertEquals((long)1L, (long)related.size());
        Assert.assertTrue((boolean)related.contains(a));
        Assert.assertEquals((Object)"a2", (Object)a.getArtistName());
        Assert.assertTrue((String)"Looks like relationship query didn't cause a snapshot refresh", (v < a.getSnapshotVersion() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Looks like relationship query didn't cause a snapshot refresh", (writeCalls < a.getPropertyWrittenDirectly() ? 1 : 0) != 0);
    }
}

