/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.AbstractToDbToken;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

public class SetAllowNullToDb
extends AbstractToDbToken.EntityAndColumn {
    public SetAllowNullToDb(DbEntity entity, DbAttribute column) {
        super("Set Allow Null", entity, column);
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        StringBuilder sqlBuffer = new StringBuilder();
        QuotingStrategy context = adapter.getQuotingStrategy();
        sqlBuffer.append("ALTER TABLE ");
        sqlBuffer.append(context.quotedFullyQualifiedName(this.getEntity()));
        sqlBuffer.append(" ALTER COLUMN ");
        sqlBuffer.append(context.quotedName(this.getColumn()));
        sqlBuffer.append(" DROP NOT NULL");
        return Collections.singletonList(sqlBuffer.toString());
    }

    @Override
    public MergerToken createReverse(MergerFactory factory) {
        return factory.createSetNotNullToModel(this.getEntity(), this.getColumn());
    }
}

