/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.MergeDirection;
import org.apache.cayenne.merge.MergerContext;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.validation.SimpleValidationFailure;

public abstract class AbstractToDbToken
implements MergerToken,
Comparable<MergerToken> {
    private final String tokenName;

    protected AbstractToDbToken(String tokenName) {
        this.tokenName = tokenName;
    }

    @Override
    public final String getTokenName() {
        return this.tokenName;
    }

    @Override
    public final MergeDirection getDirection() {
        return MergeDirection.TO_DB;
    }

    @Override
    public void execute(MergerContext mergerContext) {
        for (String sql : this.createSql(mergerContext.getAdapter())) {
            this.executeSql(mergerContext, sql);
        }
    }

    protected void executeSql(MergerContext mergerContext, String sql) {
        JdbcEventLogger logger = mergerContext.getDataNode().getJdbcEventLogger();
        logger.log(sql);
        try (Connection conn = mergerContext.getDataNode().getDataSource().getConnection();
             Statement st = conn.createStatement();){
            st.execute(sql);
        }
        catch (SQLException e) {
            mergerContext.getValidationResult().addFailure(new SimpleValidationFailure(sql, e.getMessage()));
            logger.logQueryError(e);
        }
    }

    public String toString() {
        return this.getTokenName() + ' ' + this.getTokenValue() + ' ' + (Object)((Object)this.getDirection());
    }

    public abstract List<String> createSql(DbAdapter var1);

    static abstract class EntityAndColumn
    extends Entity {
        private DbAttribute column;

        public EntityAndColumn(String tokenName, DbEntity entity, DbAttribute column) {
            super(tokenName, entity);
            this.column = column;
        }

        public DbAttribute getColumn() {
            return this.column;
        }

        @Override
        public String getTokenValue() {
            return this.getEntity().getName() + "." + this.getColumn().getName();
        }
    }

    static abstract class Entity
    extends AbstractToDbToken {
        private DbEntity entity;

        public Entity(String tokenName, DbEntity entity) {
            super(tokenName);
            this.entity = entity;
        }

        public DbEntity getEntity() {
            return this.entity;
        }

        @Override
        public String getTokenValue() {
            return this.getEntity().getName();
        }

        @Override
        public int compareTo(MergerToken o) {
            return 0;
        }
    }
}

