/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map.naming;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.cayenne.util.EqualsBuilder;
import org.apache.cayenne.util.HashCodeBuilder;
import org.apache.commons.lang.builder.CompareToBuilder;

public class ExportedKey
implements Comparable {
    public final String pkCatalog;
    public final String pkSchema;
    public final String pkTable;
    public final String pkColumn;
    public final String fkCatalog;
    public final String fkSchema;
    public final String fkTable;
    public final String fkColumn;
    public final String fkName;
    public final String pkName;
    public final short keySeq;

    public ExportedKey(String pkTable, String pkColumn, String pkName, String fkTable, String fkColumn, String fkName, short keySeq) {
        this(null, null, pkTable, pkColumn, pkName, null, null, fkTable, fkColumn, fkName, keySeq);
    }

    public ExportedKey(String pkCatalog, String pkSchema, String pkTable, String pkColumn, String pkName, String fkCatalog, String fkSchema, String fkTable, String fkColumn, String fkName, short keySeq) {
        this.pkCatalog = pkCatalog;
        this.pkSchema = pkSchema;
        this.pkTable = pkTable;
        this.pkColumn = pkColumn;
        this.pkName = pkName;
        this.fkCatalog = fkCatalog;
        this.fkSchema = fkSchema;
        this.fkTable = fkTable;
        this.fkColumn = fkColumn;
        this.fkName = fkName;
        this.keySeq = keySeq;
    }

    public static ExportedKey extractData(ResultSet rs) throws SQLException {
        return new ExportedKey(rs.getString("PKTABLE_CAT"), rs.getString("PKTABLE_SCHEM"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"), rs.getString("PK_NAME"), rs.getString("FKTABLE_CAT"), rs.getString("FKTABLE_SCHEM"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("FK_NAME"), rs.getShort("KEY_SEQ"));
    }

    public String getPkCatalog() {
        return this.pkCatalog;
    }

    public String getPkSchema() {
        return this.pkSchema;
    }

    public String getFkCatalog() {
        return this.fkCatalog;
    }

    public String getFkSchema() {
        return this.fkSchema;
    }

    public String getPKTableName() {
        return this.pkTable;
    }

    public String getFKTableName() {
        return this.fkTable;
    }

    public String getPKColumnName() {
        return this.pkColumn;
    }

    public String getFKColumnName() {
        return this.fkColumn;
    }

    public String getPKName() {
        return this.pkName;
    }

    public String getFKName() {
        return this.fkName;
    }

    public short getKeySeq() {
        return this.keySeq;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ExportedKey rhs = (ExportedKey)obj;
        return new EqualsBuilder().append(this.pkCatalog, rhs.pkCatalog).append(this.pkSchema, rhs.pkSchema).append(this.pkTable, rhs.pkTable).append(this.pkColumn, rhs.pkColumn).append(this.fkCatalog, rhs.fkCatalog).append(this.fkSchema, rhs.fkSchema).append(this.fkTable, rhs.fkTable).append(this.fkColumn, rhs.fkColumn).append(this.fkName, rhs.fkName).append(this.pkName, rhs.pkName).append(this.keySeq, rhs.keySeq).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.pkCatalog).append(this.pkSchema).append(this.pkTable).append(this.pkColumn).append(this.fkCatalog).append(this.fkSchema).append(this.fkTable).append(this.fkColumn).append(this.fkName).append(this.pkName).append(this.keySeq).toHashCode();
    }

    public int compareTo(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException();
        }
        if (obj == this) {
            return 0;
        }
        ExportedKey rhs = (ExportedKey)obj;
        return new CompareToBuilder().append((Object)this.pkCatalog, (Object)rhs.pkCatalog).append((Object)this.pkSchema, (Object)rhs.pkSchema).append((Object)this.pkTable, (Object)rhs.pkTable).append((Object)this.pkName, (Object)rhs.pkName).append((Object)this.fkCatalog, (Object)rhs.fkCatalog).append((Object)this.fkSchema, (Object)rhs.fkSchema).append((Object)this.fkTable, (Object)rhs.fkTable).append((Object)this.fkName, (Object)rhs.fkName).append(this.keySeq, rhs.keySeq).append((Object)this.pkColumn, (Object)rhs.pkColumn).append((Object)this.fkColumn, (Object)rhs.fkColumn).toComparison();
    }

    public String toString() {
        return this.getStrKey() + " # " + this.keySeq;
    }

    public String getStrKey() {
        return this.pkCatalog + "." + this.pkSchema + "." + this.pkTable + "." + this.pkColumn + " <- " + this.fkCatalog + "." + this.fkSchema + "." + this.fkTable + "." + this.fkColumn;
    }
}

