/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.ingres;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.access.translator.select.SelectTranslator;
import org.apache.cayenne.access.translator.select.TrimmingQualifierTranslator;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dba.ingres.IngresActionBuilder;
import org.apache.cayenne.dba.ingres.IngresBooleanType;
import org.apache.cayenne.dba.ingres.IngresCharType;
import org.apache.cayenne.dba.ingres.IngresMergerFactory;
import org.apache.cayenne.dba.ingres.IngresPkGenerator;
import org.apache.cayenne.dba.ingres.IngresSelectTranslator;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.resource.ResourceLocator;

public class IngresAdapter
extends JdbcAdapter {
    public static final String TRIM_FUNCTION = "TRIM";

    public IngresAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject(value="cayenne.server.resource_locator") ResourceLocator resourceLocator) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, resourceLocator);
        this.setSupportsUniqueConstraints(true);
        this.setSupportsGeneratedKeys(true);
    }

    @Override
    public SelectTranslator getSelectTranslator(SelectQuery<?> query, EntityResolver entityResolver) {
        return new IngresSelectTranslator(query, this, entityResolver);
    }

    @Override
    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        return new TrimmingQualifierTranslator(queryAssembler, TRIM_FUNCTION);
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new IngresActionBuilder(node));
    }

    @Override
    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new IngresCharType());
        map.registerType(new IngresBooleanType());
    }

    @Override
    protected PkGenerator createPkGenerator() {
        return new IngresPkGenerator(this);
    }

    @Override
    public void bindParameter(PreparedStatement statement, Object object, int pos, int sqlType, int scale) throws SQLException, Exception {
        if (object == null && (sqlType == 16 || sqlType == -7)) {
            statement.setNull(pos, 12);
        } else {
            super.bindParameter(statement, object, pos, sqlType, scale);
        }
    }

    @Override
    public MergerFactory mergerFactory() {
        return new IngresMergerFactory();
    }

    @Override
    public void createTableAppendColumn(StringBuffer buf, DbAttribute at) {
        String[] types = this.externalTypesForJdbcType(at.getType());
        if (types == null || types.length == 0) {
            throw new CayenneRuntimeException("Undefined type for attribute '" + at.getEntity().getFullyQualifiedName() + "." + at.getName() + "': " + at.getType(), new Object[0]);
        }
        String type = types[0];
        buf.append(this.quotingStrategy.quotedName(at)).append(' ').append(type);
        if (this.typeSupportsLength(at.getType())) {
            int scale;
            int len = at.getMaxLength();
            int n = scale = TypesMapping.isDecimal(at.getType()) ? at.getScale() : -1;
            if (scale > len) {
                scale = -1;
            }
            if (len > 0) {
                buf.append('(').append(len);
                if (scale >= 0) {
                    buf.append(", ").append(scale);
                }
                buf.append(')');
            }
        }
        if (at.isGenerated()) {
            buf.append(" GENERATED BY DEFAULT AS IDENTITY ");
        }
        if (at.isMandatory()) {
            buf.append(" NOT NULL");
        }
    }
}

