/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import javax.sql.DataSource;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.configuration.CayenneRuntime;
import org.apache.cayenne.configuration.ModuleCollection;
import org.apache.cayenne.configuration.server.ServerModule;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.tx.TransactionManager;
import org.apache.cayenne.tx.TransactionalOperation;

public class ServerRuntime
extends CayenneRuntime {
    private static ModuleCollection mainModule(String ... configurationLocations) {
        return new ModuleCollection(new ServerModule(configurationLocations));
    }

    public ServerRuntime(String configurationLocation, Module ... extraModules) {
        super(ServerRuntime.mainModule(configurationLocation).add(extraModules));
    }

    public ServerRuntime(String[] configurationLocations, Module ... extraModules) {
        super(ServerRuntime.mainModule(configurationLocations).add(extraModules));
    }

    public <T> T performInTransaction(TransactionalOperation<T> op) {
        TransactionManager tm = (TransactionManager)this.injector.getInstance(TransactionManager.class);
        return tm.performInTransaction(op);
    }

    public DataDomain getDataDomain() {
        return (DataDomain)this.injector.getInstance(DataDomain.class);
    }

    public DataSource getDataSource() {
        DataDomain domain = this.getDataDomain();
        DataNode defaultNode = domain.getDefaultNode();
        if (defaultNode == null) {
            int s = domain.getDataNodes().size();
            if (s == 0) {
                throw new IllegalStateException("No DataSources configured");
            }
            throw new IllegalArgumentException("No default DataSource configured. You can get explicitly named DataSource by using 'getDataSource(String)'");
        }
        return defaultNode.getDataSource();
    }

    public DataSource getDataSource(String dataNodeName) {
        DataDomain domain = this.getDataDomain();
        if (dataNodeName == null) {
            return this.getDataSource();
        }
        DataNode node = domain.getDataNode(dataNodeName);
        if (node == null) {
            throw new IllegalArgumentException("Unknown DataNode name: " + dataNodeName);
        }
        return node.getDataSource();
    }
}

