/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.cache;

import java.util.List;
import java.util.Map;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.reflect.ClassDescriptor;

public class NestedQueryCache
implements QueryCache {
    private static final String NAMESPACE_PREXIX = "#nested-";
    private static volatile int currentId;
    protected QueryCache delegate;
    protected String namespace;

    private static final int nextInt() {
        if (currentId == Integer.MAX_VALUE) {
            currentId = 0;
        }
        return currentId++;
    }

    public NestedQueryCache(QueryCache delegate) {
        this.delegate = delegate;
        this.namespace = NAMESPACE_PREXIX + NestedQueryCache.nextInt() + ":";
    }

    public QueryCache getDelegate() {
        return this.delegate;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public List get(QueryMetadata metadata, QueryCacheEntryFactory factory) {
        return this.delegate.get(this.qualifiedMetadata(metadata), factory);
    }

    @Override
    public List get(QueryMetadata metadata) {
        return this.delegate.get(this.qualifiedMetadata(metadata));
    }

    @Override
    public void put(QueryMetadata metadata, List results) {
        this.delegate.put(this.qualifiedMetadata(metadata), results);
    }

    @Override
    public void remove(String key) {
        this.delegate.remove(this.qualifiedKey(key));
    }

    @Override
    public void removeGroup(String groupKey) {
        this.delegate.removeGroup(groupKey);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    private String qualifiedKey(String key) {
        return key != null ? this.namespace + key : null;
    }

    private QueryMetadata qualifiedMetadata(QueryMetadata md) {
        return new QualifiedKeyQueryMetadata(md);
    }

    final class QualifiedKeyQueryMetadata
    implements QueryMetadata {
        private QueryMetadata mdDelegate;

        QualifiedKeyQueryMetadata(QueryMetadata mdDelegate) {
            this.mdDelegate = mdDelegate;
        }

        @Override
        public String[] getCacheGroups() {
            return this.mdDelegate.getCacheGroups();
        }

        @Override
        public String getCacheKey() {
            return NestedQueryCache.this.qualifiedKey(this.mdDelegate.getCacheKey());
        }

        @Override
        public QueryCacheStrategy getCacheStrategy() {
            return this.mdDelegate.getCacheStrategy();
        }

        @Override
        public ClassDescriptor getClassDescriptor() {
            return this.mdDelegate.getClassDescriptor();
        }

        @Override
        public DataMap getDataMap() {
            return this.mdDelegate.getDataMap();
        }

        @Override
        public DbEntity getDbEntity() {
            return this.mdDelegate.getDbEntity();
        }

        @Override
        public int getFetchLimit() {
            return this.mdDelegate.getFetchLimit();
        }

        @Override
        public int getFetchOffset() {
            return this.mdDelegate.getFetchOffset();
        }

        @Override
        public ObjEntity getObjEntity() {
            return this.mdDelegate.getObjEntity();
        }

        @Override
        public Query getOrginatingQuery() {
            return this.mdDelegate.getOrginatingQuery();
        }

        @Override
        public int getPageSize() {
            return this.mdDelegate.getPageSize();
        }

        @Override
        public PrefetchTreeNode getPrefetchTree() {
            return this.mdDelegate.getPrefetchTree();
        }

        @Override
        public Map<String, String> getPathSplitAliases() {
            return this.mdDelegate.getPathSplitAliases();
        }

        @Override
        public Procedure getProcedure() {
            return this.mdDelegate.getProcedure();
        }

        @Override
        public List<Object> getResultSetMapping() {
            return this.mdDelegate.getResultSetMapping();
        }

        @Override
        public boolean isFetchingDataRows() {
            return this.mdDelegate.isFetchingDataRows();
        }

        @Override
        public boolean isRefreshingObjects() {
            return this.mdDelegate.isRefreshingObjects();
        }

        @Override
        public int getStatementFetchSize() {
            return this.mdDelegate.getStatementFetchSize();
        }
    }
}

