/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.Validating;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.NodeDiff;
import org.apache.cayenne.validation.ValidationException;
import org.apache.cayenne.validation.ValidationResult;

class ObjectStoreGraphDiff
implements GraphDiff {
    private ObjectStore objectStore;
    private GraphDiff resolvedDiff;

    ObjectStoreGraphDiff(ObjectStore objectStore) {
        this.objectStore = objectStore;
        this.preprocess(objectStore);
    }

    Map<Object, ObjectDiff> getChangesByObjectId() {
        return this.objectStore.getChangesByObjectId();
    }

    boolean validateAndCheckNoop() {
        if (this.getChangesByObjectId().isEmpty()) {
            return true;
        }
        boolean noop = true;
        ArrayList<Validating> objectsToValidate = null;
        for (ObjectDiff diff : this.getChangesByObjectId().values()) {
            if (diff.isNoop()) continue;
            noop = false;
            if (!(diff.getObject() instanceof Validating)) continue;
            if (objectsToValidate == null) {
                objectsToValidate = new ArrayList<Validating>();
            }
            objectsToValidate.add((Validating)diff.getObject());
        }
        if (objectsToValidate != null) {
            ValidationResult result = new ValidationResult();
            for (Validating object : objectsToValidate) {
                switch (((Persistent)((Object)object)).getPersistenceState()) {
                    case 2: {
                        object.validateForInsert(result);
                        break;
                    }
                    case 4: {
                        object.validateForUpdate(result);
                        break;
                    }
                    case 6: {
                        object.validateForDelete(result);
                    }
                }
            }
            if (result.hasFailures()) {
                throw new ValidationException(result);
            }
        }
        return noop;
    }

    @Override
    public boolean isNoop() {
        if (this.getChangesByObjectId().isEmpty()) {
            return true;
        }
        for (ObjectDiff diff : this.getChangesByObjectId().values()) {
            if (diff.isNoop()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void apply(GraphChangeHandler handler) {
        this.resolveDiff();
        this.resolvedDiff.apply(handler);
    }

    @Override
    public void undo(GraphChangeHandler handler) {
        this.resolveDiff();
        this.resolvedDiff.undo(handler);
    }

    private void resolveDiff() {
        if (this.resolvedDiff == null) {
            CompoundDiff diff = new CompoundDiff();
            Map<Object, ObjectDiff> changes = this.getChangesByObjectId();
            if (!changes.isEmpty()) {
                ArrayList<NodeDiff> allChanges = new ArrayList<NodeDiff>(changes.size() * 2);
                for (ObjectDiff objectDiff : changes.values()) {
                    objectDiff.appendDiffs(allChanges);
                }
                Collections.sort(allChanges);
                diff.addAll(allChanges);
            }
            this.resolvedDiff = diff;
        }
    }

    private void preprocess(ObjectStore objectStore) {
        Map<Object, ObjectDiff> changes = this.getChangesByObjectId();
        if (!changes.isEmpty()) {
            for (Map.Entry<Object, ObjectDiff> entry : changes.entrySet()) {
                Persistent object;
                ObjectId objectId;
                ObjectId id = (ObjectId)entry.getKey();
                if (id.equals(objectId = (object = (Persistent)objectStore.getNode(id)).getObjectId())) continue;
                if (objectId != null) {
                    Map<String, Object> replacement = id.getReplacementIdMap();
                    replacement.clear();
                    replacement.putAll(objectId.getIdSnapshot());
                }
                object.setObjectId(id);
            }
        }
    }
}

