/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.DataDomainFlushAction;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.FlattenedArcKey;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.DeleteBatchQuery;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.query.Query;

class DataDomainFlattenedBucket {
    final DataDomainFlushAction parent;
    final Map<DbEntity, InsertBatchQuery> flattenedInsertQueries;
    final Map<DbEntity, DeleteBatchQuery> flattenedDeleteQueries;

    DataDomainFlattenedBucket(DataDomainFlushAction parent) {
        this.parent = parent;
        this.flattenedInsertQueries = new HashMap<DbEntity, InsertBatchQuery>();
        this.flattenedDeleteQueries = new HashMap<DbEntity, DeleteBatchQuery>();
    }

    boolean isEmpty() {
        return this.flattenedInsertQueries.isEmpty() && this.flattenedDeleteQueries.isEmpty();
    }

    void addFlattenedInsert(DbEntity flattenedEntity, FlattenedArcKey flattenedArcKey) {
        InsertBatchQuery relationInsertQuery = this.flattenedInsertQueries.get(flattenedEntity);
        if (relationInsertQuery == null) {
            relationInsertQuery = new InsertBatchQuery(flattenedEntity, 50);
            this.flattenedInsertQueries.put(flattenedEntity, relationInsertQuery);
        }
        DataNode node = this.parent.getDomain().lookupDataNode(flattenedEntity.getDataMap());
        Map<String, Object> flattenedSnapshot = flattenedArcKey.buildJoinSnapshotForInsert(node);
        relationInsertQuery.add(flattenedSnapshot);
    }

    void addFlattenedDelete(DbEntity flattenedEntity, FlattenedArcKey flattenedDeleteInfo) {
        DataNode node;
        List flattenedSnapshots;
        DeleteBatchQuery relationDeleteQuery = this.flattenedDeleteQueries.get(flattenedEntity);
        if (relationDeleteQuery == null) {
            boolean optimisticLocking = false;
            Collection<DbAttribute> pk = flattenedEntity.getPrimaryKeys();
            List<Object> pkList = pk instanceof List ? (List<Object>)pk : new ArrayList<DbAttribute>(pk);
            relationDeleteQuery = new DeleteBatchQuery(flattenedEntity, (List<DbAttribute>)pkList, Collections.emptySet(), 50);
            relationDeleteQuery.setUsingOptimisticLocking(optimisticLocking);
            this.flattenedDeleteQueries.put(flattenedEntity, relationDeleteQuery);
        }
        if (!(flattenedSnapshots = flattenedDeleteInfo.buildJoinSnapshotsForDelete(node = this.parent.getDomain().lookupDataNode(flattenedEntity.getDataMap()))).isEmpty()) {
            Iterator snapsIt = flattenedSnapshots.iterator();
            while (snapsIt.hasNext()) {
                relationDeleteQuery.add((Map)snapsIt.next());
            }
        }
    }

    void appendInserts(Collection<Query> queries) {
        if (!this.flattenedInsertQueries.isEmpty()) {
            queries.addAll(this.flattenedInsertQueries.values());
        }
    }

    void appendDeletes(Collection<Query> queries) {
        if (!this.flattenedDeleteQueries.isEmpty()) {
            queries.addAll(this.flattenedDeleteQueries.values());
        }
    }
}

