/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.DataChannelListener;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.event.SnapshotEvent;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphEvent;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.Util;

class DataContextMergeHandler
implements GraphChangeHandler,
DataChannelListener {
    private boolean active = true;
    private DataContext context;

    DataContextMergeHandler(DataContext context) {
        this.context = context;
    }

    void setActive(boolean active) {
        this.active = active;
    }

    private boolean shouldProcessEvent(GraphEvent e) {
        if (!this.active) {
            return false;
        }
        return e.getSource() == this.context.getChannel() && e.getPostedBy() != this.context && e.getPostedBy() != this.context.getChannel();
    }

    private PropertyDescriptor propertyForId(Object nodeId, String propertyName) {
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(((ObjectId)nodeId).getEntityName());
        return descriptor.getProperty(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void graphChanged(GraphEvent event) {
        if (this.shouldProcessEvent(event)) {
            GraphDiff diff = event.getDiff();
            if (diff instanceof ObjectStore.SnapshotEventDecorator) {
                SnapshotEvent decoratedEvent = ((ObjectStore.SnapshotEventDecorator)diff).getEvent();
                this.context.getObjectStore().processSnapshotEvent(decoratedEvent);
            } else {
                ObjectStore objectStore = this.context.getObjectStore();
                synchronized (objectStore) {
                    diff.apply(this);
                }
            }
            this.context.fireDataChannelChanged(event.getPostedBy(), event.getDiff());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void graphFlushed(GraphEvent event) {
        if (this.shouldProcessEvent(event)) {
            ObjectStore objectStore = this.context.getObjectStore();
            synchronized (objectStore) {
                event.getDiff().apply(this);
            }
            this.context.fireDataChannelChanged(event.getPostedBy(), event.getDiff());
        }
    }

    @Override
    public void graphRolledback(GraphEvent event) {
    }

    @Override
    public void nodeIdChanged(Object nodeId, Object newId) {
        this.context.getObjectStore().processIdChange(nodeId, newId);
    }

    @Override
    public void nodeCreated(Object nodeId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeRemoved(Object nodeId) {
        ObjectStore os;
        ObjectStore objectStore = os = this.context.getObjectStore();
        synchronized (objectStore) {
            os.processDeletedID(nodeId);
        }
    }

    @Override
    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        PropertyDescriptor p;
        Persistent object = (Persistent)this.context.getGraphManager().getNode(nodeId);
        if (object != null && object.getPersistenceState() != 5 && Util.nullSafeEquals((p = this.propertyForId(nodeId, property)).readPropertyDirectly(object), oldValue)) {
            p.writePropertyDirectly(object, oldValue, newValue);
        }
    }

    @Override
    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        this.arcChanged(nodeId, targetNodeId, arcId);
    }

    @Override
    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        this.arcChanged(nodeId, targetNodeId, arcId);
    }

    private void arcChanged(Object nodeId, Object targetNodeId, Object arcId) {
        final Persistent source = (Persistent)this.context.getGraphManager().getNode(nodeId);
        if (source != null && source.getPersistenceState() != 5) {
            final int state = source.getPersistenceState();
            PropertyDescriptor p = this.propertyForId(nodeId, arcId.toString());
            p.visit(new PropertyVisitor(){

                @Override
                public boolean visitAttribute(AttributeProperty property) {
                    return false;
                }

                @Override
                public boolean visitToMany(ToManyProperty property) {
                    if (state == 3) {
                        property.invalidate(source);
                    }
                    return false;
                }

                @Override
                public boolean visitToOne(ToOneProperty property) {
                    if (state == 3) {
                        property.invalidate(source);
                    }
                    return false;
                }
            });
        }
    }
}

