/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.io.File;
import java.io.FileWriter;
import java.util.Map;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.util.MockSerializable;
import org.apache.cayenne.util.Util;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UtilTest {
    private File fTmpFileInCurrentDir;
    private String fTmpFileName;
    private File fTmpFileCopy;

    @Before
    public void setUp() throws Exception {
        this.fTmpFileName = "." + File.separator + System.currentTimeMillis() + ".tmp";
        this.fTmpFileInCurrentDir = new File(this.fTmpFileName);
        try (FileWriter fout = new FileWriter(this.fTmpFileInCurrentDir);){
            fout.write("This is total garbage..");
        }
        this.fTmpFileCopy = new File(this.fTmpFileName + ".copy");
    }

    @After
    public void tearDown() throws Exception {
        if (!this.fTmpFileInCurrentDir.delete()) {
            throw new Exception("Error deleting temporary file: " + this.fTmpFileInCurrentDir);
        }
        if (this.fTmpFileCopy.exists() && !this.fTmpFileCopy.delete()) {
            throw new Exception("Error deleting temporary file: " + this.fTmpFileCopy);
        }
    }

    @Test
    public void testGetJavaClass() throws Exception {
        Assert.assertEquals((Object)Byte.TYPE.getName(), (Object)Util.getJavaClass("byte").getName());
        Assert.assertEquals((Object)byte[].class.getName(), (Object)Util.getJavaClass("byte[]").getName());
        Assert.assertEquals((Object)String[].class.getName(), (Object)Util.getJavaClass("java.lang.String[]").getName());
        Assert.assertEquals((Object)new UtilTest[0].getClass().getName(), (Object)Util.getJavaClass(this.getClass().getName() + "[]").getName());
    }

    @Test
    public void testToMap() {
        Object[] keys = new Object[]{"a", "b"};
        Object[] values = new Object[]{"1", "2"};
        Map<Object, Object> map = Util.toMap(keys, values);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"1", (Object)map.get("a"));
        Assert.assertEquals((Object)"2", (Object)map.get("b"));
        map.put("c", "3");
        Map<String, Object> emptyMap = Util.toMap(null, new Object[0]);
        Assert.assertTrue((boolean)emptyMap.isEmpty());
        emptyMap.put("key1", "value1");
        Object[] values2 = new Object[]{"1"};
        try {
            Util.toMap(keys, values2);
            Assert.fail((String)"must have thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    @Test
    public void testStripLineBreaks() {
        Assert.assertEquals((Object)"PnMusdkams34 H AnYtk M", (Object)Util.stripLineBreaks("PnMusdkams34 H AnYtk M", 'A'));
        Assert.assertEquals((Object)"TyusdsdsdQaAbAc", (Object)Util.stripLineBreaks("TyusdsdsdQa\r\nb\r\nc", 'A'));
        Assert.assertEquals((Object)"aBbBc", (Object)Util.stripLineBreaks("a\rb\rc", 'B'));
        Assert.assertEquals((Object)"aCbCc", (Object)Util.stripLineBreaks("a\nb\nc", 'C'));
    }

    @Test
    public void testCloneViaSerialization() throws Exception {
        MockSerializable o1 = new MockSerializable();
        MockSerializable o2 = Util.cloneViaSerialization(o1);
        Assert.assertEquals((Object)o1, (Object)o2);
        Assert.assertTrue((o1 != o2 ? 1 : 0) != 0);
    }

    @Test
    public void testPackagePath1() throws Exception {
        String expectedPath = "org/apache/cayenne/util";
        Assert.assertEquals((Object)expectedPath, (Object)Util.getPackagePath(UtilTest.class.getName()));
    }

    @Test
    public void testPackagePath2() throws Exception {
        String expectedPath = "org/apache/cayenne/util";
        class TmpTest {
            TmpTest() {
            }
        }
        Assert.assertEquals((Object)expectedPath, (Object)Util.getPackagePath(TmpTest.class.getName()));
    }

    @Test
    public void testPackagePath3() throws Exception {
        Assert.assertEquals((Object)"", (Object)Util.getPackagePath("ClassWithNoPackage"));
    }

    @Test
    public void testIsEmptyString1() throws Exception {
        Assert.assertTrue((boolean)Util.isEmptyString(""));
    }

    @Test
    public void testIsEmptyString2() throws Exception {
        Assert.assertFalse((boolean)Util.isEmptyString("  "));
    }

    @Test
    public void testIsEmptyString3() throws Exception {
        Assert.assertTrue((boolean)Util.isEmptyString(null));
    }

    @Test
    public void testBackslashFix() throws Exception {
        String strBefore = "abcd\\12345\\";
        String strAfter = "abcd/12345/";
        Assert.assertEquals((Object)strAfter, (Object)Util.substBackslashes(strBefore));
    }

    @Test
    public void testNullSafeEquals() throws Exception {
        class CloneableObject
        implements Cloneable {
            CloneableObject() {
            }

            public Object clone() throws CloneNotSupportedException {
                return super.clone();
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                return obj.getClass() == this.getClass();
            }
        }
        CloneableObject o1 = new CloneableObject();
        Object o2 = new Object();
        Object o3 = o1.clone();
        Assert.assertTrue((boolean)o3.equals(o1));
        Assert.assertTrue((boolean)Util.nullSafeEquals(o1, o1));
        Assert.assertFalse((boolean)Util.nullSafeEquals(o1, o2));
        Assert.assertTrue((boolean)Util.nullSafeEquals(o1, o3));
        Assert.assertFalse((boolean)Util.nullSafeEquals(o1, null));
        Assert.assertFalse((boolean)Util.nullSafeEquals(null, o1));
        Assert.assertTrue((boolean)Util.nullSafeEquals(null, null));
    }

    @Test
    public void testExtractFileExtension1() throws Exception {
        String fullName = "n.ext";
        Assert.assertEquals((Object)"ext", (Object)Util.extractFileExtension(fullName));
    }

    @Test
    public void testExtractFileExtension2() throws Exception {
        String fullName = "n";
        Assert.assertNull((Object)Util.extractFileExtension(fullName));
    }

    @Test
    public void testExtractFileExtension3() throws Exception {
        String fullName = ".ext";
        Assert.assertNull((Object)Util.extractFileExtension(fullName));
    }

    @Test
    public void testStripFileExtension1() throws Exception {
        String fullName = "n.ext";
        Assert.assertEquals((Object)"n", (Object)Util.stripFileExtension(fullName));
    }

    @Test
    public void testStripFileExtension2() throws Exception {
        String fullName = "n";
        Assert.assertEquals((Object)"n", (Object)Util.stripFileExtension(fullName));
    }

    @Test
    public void testStripFileExtension3() throws Exception {
        String fullName = ".ext";
        Assert.assertEquals((Object)".ext", (Object)Util.stripFileExtension(fullName));
    }

    @Test
    public void testEncodeXmlAttribute1() throws Exception {
        String unencoded = "normalstring";
        Assert.assertEquals((Object)unencoded, (Object)Util.encodeXmlAttribute(unencoded));
    }

    @Test
    public void testEncodeXmlAttribute2() throws Exception {
        String unencoded = "<a>";
        Assert.assertEquals((Object)"&lt;a&gt;", (Object)Util.encodeXmlAttribute(unencoded));
    }

    @Test
    public void testEncodeXmlAttribute3() throws Exception {
        String unencoded = "a&b";
        Assert.assertEquals((Object)"a&amp;b", (Object)Util.encodeXmlAttribute(unencoded));
    }

    @Test
    public void testUnwindException1() throws Exception {
        Throwable e = new Throwable();
        Assert.assertSame((Object)e, (Object)Util.unwindException(e));
    }

    @Test
    public void testUnwindException2() throws Exception {
        CayenneException e = new CayenneException();
        Assert.assertSame((Object)e, (Object)Util.unwindException(e));
    }

    @Test
    public void testUnwindException3() throws Exception {
        Throwable root = new Throwable();
        CayenneException e = new CayenneException(root);
        Assert.assertSame((Object)root, (Object)Util.unwindException(e));
    }

    @Test
    public void testPrettyTrim1() throws Exception {
        try {
            Util.prettyTrim("abc", 4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPrettyTrim2() throws Exception {
        Assert.assertEquals((Object)"123", (Object)Util.prettyTrim("123", 6));
        Assert.assertEquals((Object)"123456", (Object)Util.prettyTrim("123456", 6));
        Assert.assertEquals((Object)"1...67", (Object)Util.prettyTrim("1234567", 6));
        Assert.assertEquals((Object)"1...78", (Object)Util.prettyTrim("12345678", 6));
    }
}

