/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.di.server;

import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.configuration.server.DataNodeFactory;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCaseDataDomainProvider;
import org.apache.cayenne.unit.di.server.ServerCaseDataNodeFactory;
import org.apache.cayenne.unit.di.server.ServerCaseDataSourceFactory;
import org.apache.cayenne.unit.di.server.ServerCaseProperties;

public class ServerRuntimeProvider
implements Provider<ServerRuntime> {
    private ServerCaseProperties properties;
    private ServerCaseDataSourceFactory dataSourceFactory;
    private UnitDbAdapter unitDbAdapter;
    private Provider<DbAdapter> dbAdapterProvider;

    public ServerRuntimeProvider(@Inject ServerCaseDataSourceFactory dataSourceFactory, @Inject ServerCaseProperties properties, @Inject Provider<DbAdapter> dbAdapterProvider, @Inject UnitDbAdapter unitDbAdapter) {
        this.dataSourceFactory = dataSourceFactory;
        this.properties = properties;
        this.dbAdapterProvider = dbAdapterProvider;
        this.unitDbAdapter = unitDbAdapter;
    }

    public ServerRuntime get() throws ConfigurationException {
        String configurationLocation = this.properties.getConfigurationLocation();
        if (configurationLocation == null) {
            throw new NullPointerException("Null 'configurationLocation', annotate your test case with @UseServerRuntime");
        }
        return new ServerRuntime(configurationLocation, new ServerExtraModule());
    }

    class ServerExtraModule
    implements Module {
        ServerExtraModule() {
        }

        public void configure(Binder binder) {
            binder.bind(DbAdapter.class).toProviderInstance(ServerRuntimeProvider.this.dbAdapterProvider);
            binder.bind(DataDomain.class).toProvider(ServerCaseDataDomainProvider.class);
            binder.bind(DataNodeFactory.class).to(ServerCaseDataNodeFactory.class);
            binder.bind(UnitDbAdapter.class).toInstance((Object)ServerRuntimeProvider.this.unitDbAdapter);
            binder.bind(ServerCaseDataSourceFactory.class).toInstance((Object)ServerRuntimeProvider.this.dataSourceFactory);
        }
    }
}

