/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.lang.reflect.Method;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.Converter;
import org.apache.cayenne.reflect.ConverterFactory;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.PropertyUtils;

public class BeanAccessor
implements Accessor {
    private static final long serialVersionUID = 606253801447018099L;
    protected String propertyName;
    protected Method readMethod;
    protected Method writeMethod;
    protected Object nullValue;

    public BeanAccessor(Class<?> objectClass, String propertyName, Class<?> propertyType) {
        if (objectClass == null) {
            throw new IllegalArgumentException("Null objectClass");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Null propertyName");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("Empty propertyName");
        }
        this.propertyName = propertyName;
        this.nullValue = PropertyUtils.defaultNullValueForType(propertyType);
        String capitalized = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        try {
            this.readMethod = objectClass.getMethod("get" + capitalized, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                Method readMethod = objectClass.getMethod("is" + capitalized, new Class[0]);
                this.readMethod = readMethod.getReturnType().equals(Boolean.TYPE) ? readMethod : null;
            }
            catch (NoSuchMethodException e1) {
                // empty catch block
            }
        }
        if (this.readMethod == null) {
            throw new IllegalArgumentException("Property '" + propertyName + "' is not readbale");
        }
        try {
            this.writeMethod = objectClass.getMethod("set" + capitalized, this.readMethod.getReturnType());
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
    }

    @Override
    public String getName() {
        return this.propertyName;
    }

    @Override
    public Object getValue(Object object) throws PropertyException {
        try {
            return this.readMethod.invoke(object, (Object[])null);
        }
        catch (Throwable th) {
            throw new PropertyException("Error reading property: " + this.propertyName, (Accessor)this, object, th, new Object[0]);
        }
    }

    @Override
    public void setValue(Object object, Object newValue) throws PropertyException {
        if (this.writeMethod == null) {
            throw new PropertyException("Property '" + this.propertyName + "' is not writable", (Accessor)this, object, new Object[0]);
        }
        Class<?> type = this.writeMethod.getParameterTypes()[0];
        Converter<?> converter = ConverterFactory.factory.getConverter(type);
        Object object2 = newValue = converter != null ? converter.convert(newValue, type) : newValue;
        if (newValue == null) {
            newValue = this.nullValue;
        }
        try {
            this.writeMethod.invoke(object, newValue);
        }
        catch (Throwable th) {
            throw new PropertyException("Error reading property: " + this.propertyName, (Accessor)this, object, th, new Object[0]);
        }
    }
}

