/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.sql.Date;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ResultBatchIterator;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.ResultIteratorCallback;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ObjectSelect_RunIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;

    protected void createArtistsDataSet() throws Exception {
        TableHelper tArtist = new TableHelper(this.dbHelper, "ARTIST");
        tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
        long dateBase = System.currentTimeMillis();
        for (int i = 1; i <= 20; ++i) {
            tArtist.insert(new Object[]{i, "artist" + i, new Date(dateBase + (long)(10000 * i))});
        }
    }

    @Test
    public void test_SelectObjects() throws Exception {
        this.createArtistsDataSet();
        List<Artist> result = ObjectSelect.query(Artist.class).select(this.context);
        Assert.assertEquals((long)20L, (long)result.size());
        Assert.assertThat((Object)result.get(0), (Matcher)CoreMatchers.instanceOf(Artist.class));
        Artist a = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("artist14")).selectOne(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist14", (Object)a.getArtistName());
    }

    @Test
    public void test_Iterate() throws Exception {
        this.createArtistsDataSet();
        final int[] count = new int[1];
        ObjectSelect.query(Artist.class).iterate(this.context, new ResultIteratorCallback<Artist>(){

            @Override
            public void next(Artist object) {
                Assert.assertNotNull((Object)object.getArtistName());
                count[0] = count[0] + 1;
            }
        });
        Assert.assertEquals((long)20L, (long)count[0]);
    }

    @Test
    public void test_Iterator() throws Exception {
        this.createArtistsDataSet();
        try (ResultIterator<Artist> it = ObjectSelect.query(Artist.class).iterator(this.context);){
            int count = 0;
            for (Artist a : it) {
                ++count;
            }
            Assert.assertEquals((long)20L, (long)count);
        }
    }

    @Test
    public void test_BatchIterator() throws Exception {
        this.createArtistsDataSet();
        try (ResultBatchIterator<Artist> it = ObjectSelect.query(Artist.class).batchIterator(this.context, 5);){
            int count = 0;
            for (List<Artist> list : it) {
                ++count;
                Assert.assertEquals((long)5L, (long)list.size());
            }
            Assert.assertEquals((long)4L, (long)count);
        }
    }

    @Test
    public void test_SelectDataRows() throws Exception {
        this.createArtistsDataSet();
        List<DataRow> result = ObjectSelect.dataRowQuery(Artist.class).select(this.context);
        Assert.assertEquals((long)20L, (long)result.size());
        Assert.assertThat((Object)result.get(0), (Matcher)CoreMatchers.instanceOf(DataRow.class));
        DataRow a = ObjectSelect.dataRowQuery(Artist.class).where(Artist.ARTIST_NAME.eq("artist14")).selectOne(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist14", a.get("ARTIST_NAME"));
    }

    @Test
    public void test_SelectOne() throws Exception {
        this.createArtistsDataSet();
        Artist a = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("artist13")).selectOne(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist13", (Object)a.getArtistName());
    }

    @Test
    public void test_SelectOne_NoMatch() throws Exception {
        Artist a = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("artist13")).selectOne(this.context);
        Assert.assertNull((Object)a);
    }

    @Test(expected=CayenneRuntimeException.class)
    public void test_SelectOne_MoreThanOneMatch() throws Exception {
        this.createArtistsDataSet();
        ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.like("artist%")).selectOne(this.context);
    }

    @Test
    public void test_SelectFirst() throws Exception {
        this.createArtistsDataSet();
        Artist a = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("artist13")).selectFirst(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist13", (Object)a.getArtistName());
    }

    @Test
    public void test_SelectFirstByContext() throws Exception {
        this.createArtistsDataSet();
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("artist13"));
        Artist a = this.context.selectFirst(q);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist13", (Object)a.getArtistName());
    }

    @Test
    public void test_SelectFirst_NoMatch() throws Exception {
        Artist a = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("artist13")).selectFirst(this.context);
        Assert.assertNull((Object)a);
    }

    @Test
    public void test_SelectFirst_MoreThanOneMatch() throws Exception {
        this.createArtistsDataSet();
        Artist a = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.like("artist%")).orderBy("db:ARTIST_ID").selectFirst(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist1", (Object)a.getArtistName());
    }
}

