/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.merge.AbstractToModelToken;
import org.apache.cayenne.merge.AddRelationshipToModel;
import org.apache.cayenne.merge.MergerContext;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

public class DropRelationshipToModel
extends AbstractToModelToken.Entity {
    private final DbRelationship rel;

    public DropRelationshipToModel(DbEntity entity, DbRelationship rel) {
        super("Drop db-relationship ", entity);
        this.rel = rel;
    }

    @Override
    public MergerToken createReverse(MergerFactory factory) {
        return factory.createAddRelationshipToDb(this.getEntity(), this.rel);
    }

    @Override
    public void execute(MergerContext mergerContext) {
        DropRelationshipToModel.remove(mergerContext.getModelMergeDelegate(), this.rel, true);
    }

    @Override
    public String getTokenValue() {
        return AddRelationshipToModel.getTokenValue(this.rel);
    }

    public DbRelationship getRelationship() {
        return this.rel;
    }
}

