/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.log;

import java.util.Collections;
import org.apache.cayenne.configuration.DefaultRuntimeProperties;
import org.apache.cayenne.log.CommonsJdbcEventLogger;
import org.apache.cayenne.util.IDUtil;
import org.junit.Assert;
import org.junit.Test;

public class CommonsJdbcEventLoggerTest {
    @Test
    public void testSqlLiteralForObject() throws Exception {
        StringBuilder buf = new StringBuilder();
        new CommonsJdbcEventLogger(new DefaultRuntimeProperties(Collections.EMPTY_MAP)).sqlLiteralForObject(buf, new Object());
        Assert.assertTrue((buf.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAppendFormattedByte() throws Exception {
        this.assertFormatting((byte)0, "00");
        this.assertFormatting((byte)1, "01");
        this.assertFormatting((byte)10, "0A");
        this.assertFormatting((byte)127, "7F");
        this.assertFormatting((byte)-1, "FF");
        this.assertFormatting((byte)-128, "80");
    }

    private void assertFormatting(byte b, String formatted) throws Exception {
        StringBuffer buffer = new StringBuffer();
        IDUtil.appendFormattedByte(buffer, b);
        Assert.assertEquals((Object)formatted, (Object)buffer.toString());
    }
}

