/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ExpressionIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private ServerRuntime runtime;

    @Test
    public void testMatch() {
        Assert.assertTrue((boolean)(this.context instanceof DataContext));
        DataContext context2 = (DataContext)this.runtime.newContext();
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("Equals");
        Painting p1 = this.context.newObject(Painting.class);
        p1.setToArtist(a1);
        p1.setPaintingTitle("painting1");
        this.context.commitChanges();
        SelectQuery<Painting> query = new SelectQuery<Painting>(Painting.class);
        Expression e = Painting.TO_ARTIST.eq(a1);
        query.setQualifier(e);
        Assert.assertNotSame((Object)context2, (Object)this.context);
        List<Painting> objects = context2.select(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Assert.assertTrue((boolean)e.match(objects.get(0)));
        a1.setArtistName("newName");
        SelectQuery<Painting> q2 = new SelectQuery<Painting>(Painting.class);
        Expression ex2 = Painting.TO_ARTIST.eq(a1);
        q2.setQualifier(ex2);
        Assert.assertTrue((boolean)ex2.match(objects.get(0)));
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("Equals");
        this.context.commitChanges();
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class);
        Expression ex = Painting.TO_ARTIST.eq(a2);
        q.setQualifier(ex);
        Assert.assertFalse((boolean)ex.match(objects.get(0)));
    }

    @Test
    public void testFirst() {
        ArrayList<Painting> paintingList = new ArrayList<Painting>();
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("x1");
        paintingList.add(p1);
        Painting p2 = this.context.newObject(Painting.class);
        p2.setPaintingTitle("x2");
        paintingList.add(p2);
        Painting p3 = this.context.newObject(Painting.class);
        p3.setPaintingTitle("x3");
        paintingList.add(p3);
        Expression e1 = ExpressionFactory.likeExp("paintingTitle", "x%");
        Assert.assertSame((Object)p1, e1.first(paintingList));
        Expression e3 = ExpressionFactory.matchExp("paintingTitle", "x3");
        Assert.assertSame((Object)p3, e3.first(paintingList));
        Expression e4 = ExpressionFactory.matchExp("paintingTitle", "x4");
        Assert.assertNull(e4.first(paintingList));
    }
}

