/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ExpressionFactoryIT
extends ServerCase {
    @Inject
    private ObjectContext context;

    @Test
    public void testCollectionMatch() {
        Artist artist = this.context.newObject(Artist.class);
        artist.setArtistName("artist");
        Painting p1 = this.context.newObject(Painting.class);
        Painting p2 = this.context.newObject(Painting.class);
        Painting p3 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("p1");
        p2.setPaintingTitle("p2");
        p3.setPaintingTitle("p3");
        artist.addToPaintingArray(p1);
        artist.addToPaintingArray(p2);
        this.context.commitChanges();
        Assert.assertTrue((boolean)ExpressionFactory.matchExp("paintingArray", p1).match(artist));
        Assert.assertFalse((boolean)ExpressionFactory.matchExp("paintingArray", p3).match(artist));
        Assert.assertFalse((boolean)ExpressionFactory.noMatchExp("paintingArray", p1).match(artist));
        Assert.assertTrue((boolean)ExpressionFactory.noMatchExp("paintingArray", p3).match(artist));
        Assert.assertTrue((boolean)ExpressionFactory.matchExp("paintingArray.paintingTitle", "p1").match(artist));
        Assert.assertFalse((boolean)ExpressionFactory.matchExp("paintingArray.paintingTitle", "p3").match(artist));
        Assert.assertFalse((boolean)ExpressionFactory.noMatchExp("paintingArray.paintingTitle", "p1").match(artist));
        Assert.assertTrue((boolean)ExpressionFactory.noMatchExp("paintingArray.paintingTitle", "p3").match(artist));
        Assert.assertTrue((boolean)ExpressionFactory.inExp("paintingTitle", "p1").match(p1));
        Assert.assertFalse((boolean)ExpressionFactory.notInExp("paintingTitle", "p3").match(p3));
    }

    @Test
    public void testIn() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("a1");
        Painting p1 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("p1");
        Painting p2 = this.context.newObject(Painting.class);
        p2.setPaintingTitle("p2");
        a1.addToPaintingArray(p1);
        a1.addToPaintingArray(p2);
        Expression in = ExpressionFactory.inExp("paintingArray", p1);
        Assert.assertTrue((boolean)in.match(a1));
    }

    @Test
    public void testEscapeCharacter() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("A_1");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("A_2");
        this.context.commitChanges();
        Expression ex1 = ExpressionFactory.likeIgnoreCaseDbExp("ARTIST_NAME", "A*_1", '*');
        SelectQuery<Artist> q1 = new SelectQuery<Artist>(Artist.class, ex1);
        List<Artist> artists = this.context.select(q1);
        Assert.assertEquals((long)1L, (long)artists.size());
        Expression ex2 = ExpressionFactory.likeExp("artistName", "A*_2", '*');
        SelectQuery<Artist> q2 = new SelectQuery<Artist>(Artist.class, ex2);
        artists = this.context.select(q2);
        Assert.assertEquals((long)1L, (long)artists.size());
    }

    @Test
    public void testContains_Escape() {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("MA_1X");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("CA%2Y");
        this.context.commitChanges();
        Expression ex1 = ExpressionFactory.containsExp(Artist.ARTIST_NAME.getName(), "A_1");
        SelectQuery<Artist> q1 = new SelectQuery<Artist>(Artist.class, ex1);
        List<Artist> artists = this.context.select(q1);
        Assert.assertEquals((long)1L, (long)artists.size());
        Expression ex2 = ExpressionFactory.containsExp(Artist.ARTIST_NAME.getName(), "A%2");
        SelectQuery<Artist> q2 = new SelectQuery<Artist>(Artist.class, ex2);
        artists = this.context.select(q2);
        Assert.assertEquals((long)1L, (long)artists.size());
    }
}

