/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ejbql;

import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.EJBQLParser;
import org.apache.cayenne.ejbql.EJBQLParserFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EJBQLParser_ParseTest {
    private EJBQLParser parser;

    @Before
    public void before() {
        this.parser = EJBQLParserFactory.getParser();
    }

    @Test
    public void testDbPath() {
        EJBQLExpression select = this.parser.parse("select p from Painting p WHERE db:p.toArtist.ARTIST_NAME = 'a'");
        Assert.assertNotNull((Object)select);
    }

    @Test
    public void testEnumPath() {
        EJBQLExpression select = this.parser.parse("select p from Painting p WHERE p.toArtist.ARTIST_NAME = enum:org.apache.cayenne.ejbql.EJBQLEnum1.X");
        Assert.assertNotNull((Object)select);
    }

    @Test
    public void testImplicitOuterJoin() {
        EJBQLExpression select = this.parser.parse("SELECT a FROM Artist a WHERE a.paintingArray+.toGallery.galleryName = 'gallery2'");
        Assert.assertNotNull((Object)select);
    }

    @Test
    public void testInWithMultipleStringPositionalParameter_withoutBrackets() {
        try {
            this.parser.parse("select p from Painting p WHERE p.toArtist IN ?1, ?2");
            Assert.fail((String)"a test in clause with multiple unbracketed parameters parsed; should not be possible");
        }
        catch (EJBQLException ejbqlE) {
        }
        catch (Throwable th) {
            Assert.fail((String)("expected an instance of " + EJBQLException.class.getSimpleName() + " to be thrown, but; " + th.getClass().getSimpleName() + " was thrown"));
        }
    }
}

