/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.cayenne.datasource.PoolAwareConnection;
import org.apache.cayenne.datasource.PoolingDataSourceParameters;
import org.apache.cayenne.datasource.UnmanagedPoolingDataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class PoolingDataSourceTest {
    private DataSource nonPooling;
    private PoolingDataSourceParameters params;

    @Before
    public void before() throws SQLException {
        this.nonPooling = (DataSource)Mockito.mock(DataSource.class);
        Mockito.when((Object)this.nonPooling.getConnection()).thenAnswer((Answer)new Answer<Connection>(){

            public Connection answer(InvocationOnMock invocation) throws Throwable {
                return (Connection)Mockito.mock(Connection.class);
            }
        });
        this.params = new PoolingDataSourceParameters();
    }

    @Test
    public void testManagePool_High() throws SQLException {
        int max = 5;
        this.params.setMinConnections(1);
        this.params.setMaxConnections(max);
        UnmanagedPoolingDataSource ds = new UnmanagedPoolingDataSource(this.nonPooling, this.params);
        Connection[] open = new Connection[max];
        for (int i = 0; i < max; ++i) {
            open[i] = ds.getConnection();
        }
        for (Connection c : open) {
            c.close();
        }
        Assert.assertEquals((long)max, (long)ds.poolSize());
        ds.managePool();
        Assert.assertEquals((long)(max - 1), (long)ds.poolSize());
        ds.managePool();
        Assert.assertEquals((long)(max - 2), (long)ds.poolSize());
        ds.managePool();
        Assert.assertEquals((long)(max - 2), (long)ds.poolSize());
        ds.managePool();
        Assert.assertEquals((long)(max - 2), (long)ds.poolSize());
    }

    @Test
    public void testManagePool_Low() throws SQLException {
        int min = 2;
        this.params.setMinConnections(min);
        this.params.setMaxConnections(min + 5);
        UnmanagedPoolingDataSource ds = new UnmanagedPoolingDataSource(this.nonPooling, this.params);
        Assert.assertEquals((long)min, (long)ds.poolSize());
        for (int i = 0; i < min; ++i) {
            ds.retire(ds.uncheckNonBlocking(false));
        }
        Assert.assertEquals((long)0L, (long)ds.poolSize());
        ds.managePool();
        Assert.assertEquals((long)1L, (long)ds.poolSize());
        ds.managePool();
        Assert.assertEquals((long)2L, (long)ds.poolSize());
        ds.managePool();
        Assert.assertEquals((long)2L, (long)ds.poolSize());
        ds.managePool();
        Assert.assertEquals((long)2L, (long)ds.poolSize());
    }

    @Test
    public void testManagePool_Empty() throws SQLException {
        int max = 5;
        this.params.setMinConnections(1);
        this.params.setMaxConnections(max);
        UnmanagedPoolingDataSource ds = new UnmanagedPoolingDataSource(this.nonPooling, this.params);
        Connection[] open = new Connection[max];
        for (int i = 0; i < max; ++i) {
            open[i] = ds.getConnection();
        }
        Assert.assertEquals((long)max, (long)ds.poolSize());
        ds.managePool();
        Assert.assertEquals((long)max, (long)ds.poolSize());
    }

    @Test
    public void testValidateUnchecked() {
        final PoolAwareConnection[] connections = this.validConnections(4);
        this.params.setMinConnections(4);
        this.params.setMaxConnections(10);
        UnmanagedPoolingDataSource ds = new UnmanagedPoolingDataSource(this.nonPooling, this.params){
            int i;

            @Override
            PoolAwareConnection createWrapped() throws SQLException {
                return connections[this.i++];
            }
        };
        Mockito.when((Object)connections[0].validate()).thenReturn((Object)false);
        Mockito.when((Object)connections[1].validate()).thenReturn((Object)false);
        Connection faceHeadConnection = (Connection)Mockito.mock(Connection.class);
        PoolAwareConnection fakeHead = (PoolAwareConnection)Mockito.mock(PoolAwareConnection.class);
        Mockito.when((Object)fakeHead.getConnection()).thenReturn((Object)faceHeadConnection);
        Assert.assertSame((Object)connections[2], (Object)ds.validateUnchecked(fakeHead));
    }

    @Test
    public void testGetConnection_UpperCap() throws SQLException {
        int max = 5;
        this.params.setMaxConnections(max);
        this.params.setMaxQueueWaitTime(1000L);
        UnmanagedPoolingDataSource ds = new UnmanagedPoolingDataSource(this.nonPooling, this.params);
        Connection[] unchecked = new Connection[max];
        for (int i = 0; i < max; ++i) {
            unchecked[i] = ds.getConnection();
        }
        try {
            ds.getConnection();
            Assert.fail((String)"Pool overflow not checked");
        }
        catch (SQLException e) {
            // empty catch block
        }
        unchecked[0].close();
        Connection c = ds.getConnection();
        Assert.assertNotNull((Object)c);
    }

    PoolAwareConnection[] validConnections(int size) {
        PoolAwareConnection[] connections = new PoolAwareConnection[size];
        for (int i = 0; i < size; ++i) {
            Connection c = (Connection)Mockito.mock(Connection.class);
            connections[i] = (PoolAwareConnection)Mockito.mock(PoolAwareConnection.class);
            Mockito.when((Object)connections[i].getConnection()).thenReturn((Object)c);
            Mockito.when((Object)connections[i].validate()).thenReturn((Object)true);
        }
        return connections;
    }
}

