/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.ExtendedType;

public class IntegerType
implements ExtendedType {
    @Override
    public String getClassName() {
        return Integer.class.getName();
    }

    @Override
    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        int value = rs.getInt(index);
        return rs.wasNull() ? null : Integer.valueOf(value);
    }

    @Override
    public Object materializeObject(CallableStatement rs, int index, int type) throws Exception {
        int value = rs.getInt(index);
        return rs.wasNull() ? null : Integer.valueOf(value);
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, Object value, int pos, int type, int scale) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else {
            statement.setInt(pos, ((Number)value).intValue());
        }
    }
}

