/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader.mapper;

import java.util.Iterator;
import java.util.TreeSet;
import org.apache.cayenne.access.loader.mapper.DbType;
import org.junit.Assert;
import org.junit.Test;

public class DbTypeTest {
    @Test
    public void testCompareTo() throws Exception {
        TreeSet<DbType> set = new TreeSet<DbType>();
        set.add(new DbType("type-01", null, null, null, null));
        set.add(new DbType("type-02", null, null, null, null));
        set.add(new DbType("type-02", 1, null, null, null));
        set.add(new DbType("type-02", 2, null, null, null));
        set.add(new DbType("type-02", 2, null, null, true));
        set.add(new DbType("type-02", 2, null, null, false));
        set.add(new DbType("type-02", 2, null, 5, null));
        set.add(new DbType("type-02", 2, null, 5, false));
        set.add(new DbType("type-02", 2, null, 5, true));
        set.add(new DbType("type-02", null, 8, 5, true));
        set.add(new DbType("type-02", null, 9, 5, true));
        Iterator iterator = set.iterator();
        Assert.assertEquals((Object)new DbType("type-02", 2, null, 5, true), iterator.next());
        Assert.assertEquals((Object)new DbType("type-02", 2, null, 5, false), iterator.next());
        Assert.assertEquals((Object)new DbType("type-02", null, 9, 5, true), iterator.next());
        Assert.assertEquals((Object)new DbType("type-02", null, 8, 5, true), iterator.next());
        Assert.assertEquals((Object)new DbType("type-02", 2, null, 5, null), iterator.next());
        Assert.assertEquals((Object)new DbType("type-02", 2, null, null, true), iterator.next());
        Assert.assertEquals((Object)new DbType("type-02", 2, null, null, false), iterator.next());
        Assert.assertEquals((Object)new DbType("type-02", 2, null, null, null), iterator.next());
        Assert.assertEquals((Object)new DbType("type-02", 1, null, null, null), iterator.next());
        Assert.assertEquals((Object)new DbType("type-02", null, null, null, null), iterator.next());
        Assert.assertEquals((Object)new DbType("type-01", null, null, null, null), iterator.next());
    }

    @Test
    public void testCover() throws Exception {
        DbType typeJava = new DbType("java");
        Assert.assertTrue((boolean)typeJava.isCover(typeJava));
        Assert.assertTrue((boolean)typeJava.isCover(new DbType("java", 1, 1, 1, null)));
        Assert.assertTrue((boolean)typeJava.isCover(new DbType("java", 1, null, null, null)));
        Assert.assertTrue((boolean)typeJava.isCover(new DbType("java", null, 1, null, null)));
        Assert.assertTrue((boolean)typeJava.isCover(new DbType("java", null, null, 1, null)));
        Assert.assertTrue((boolean)typeJava.isCover(new DbType("java", null, null, null, true)));
        Assert.assertTrue((boolean)typeJava.isCover(new DbType("java", null, null, null, false)));
        Assert.assertFalse((boolean)typeJava.isCover(new DbType("java1", null, null, null, null)));
        DbType typeWithLength = new DbType("java", 1, null, null, null);
        Assert.assertTrue((boolean)typeWithLength.isCover(typeWithLength));
        Assert.assertTrue((boolean)typeWithLength.isCover(new DbType("java", 1, null, 1, null)));
        Assert.assertTrue((boolean)typeWithLength.isCover(new DbType("java", 1, null, 1, true)));
        Assert.assertTrue((boolean)typeWithLength.isCover(new DbType("java", 1, null, null, true)));
        Assert.assertTrue((boolean)typeWithLength.isCover(new DbType("java", 1, 1, null, true)));
        Assert.assertFalse((boolean)typeWithLength.isCover(new DbType("java", 2, null, null, null)));
        Assert.assertFalse((boolean)typeWithLength.isCover(new DbType("java", null, null, null, true)));
        Assert.assertFalse((boolean)typeWithLength.isCover(new DbType("java1", 2, null, null, null)));
        DbType typeWithLengthAndNotNull = new DbType("java", 1, null, null, true);
        Assert.assertTrue((boolean)typeWithLength.isCover(typeWithLengthAndNotNull));
        Assert.assertTrue((boolean)typeWithLength.isCover(new DbType("java", 1, null, 1, true)));
        Assert.assertTrue((boolean)typeWithLength.isCover(new DbType("java", 1, 1, 1, true)));
    }
}

