/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader.filters;

import java.util.TreeSet;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.cayenne.access.loader.filters.IncludeTableFilter;
import org.apache.cayenne.access.loader.filters.PatternFilter;
import org.apache.cayenne.access.loader.filters.TableFilter;

public class TableFilterTest
extends TestCase {
    public void testIncludeEverything() {
        TableFilter filter = TableFilter.everything();
        TableFilterTest.assertNotNull((Object)filter.isIncludeTable("table"));
        TableFilterTest.assertNotNull((Object)filter.isIncludeTable("aaaa"));
        TableFilterTest.assertNotNull((Object)filter.isIncludeTable(""));
        TableFilterTest.assertNotNull((Object)filter.isIncludeTable("alex"));
    }

    public void testInclude() {
        TreeSet<IncludeTableFilter> includes = new TreeSet<IncludeTableFilter>();
        includes.add(new IncludeTableFilter("aaa"));
        includes.add(new IncludeTableFilter("bb"));
        TableFilter filter = new TableFilter(includes, new TreeSet<Pattern>(PatternFilter.PATTERN_COMPARATOR));
        TableFilterTest.assertNotNull((Object)filter.isIncludeTable("aaa"));
        TableFilterTest.assertNull((Object)filter.isIncludeTable("aa"));
        TableFilterTest.assertNull((Object)filter.isIncludeTable("aaaa"));
        TableFilterTest.assertNotNull((Object)filter.isIncludeTable("bb"));
        TableFilterTest.assertNull((Object)filter.isIncludeTable(""));
        TableFilterTest.assertNull((Object)filter.isIncludeTable("bbbb"));
    }

    public void testExclude() {
        TreeSet<Pattern> excludes = new TreeSet<Pattern>(PatternFilter.PATTERN_COMPARATOR);
        excludes.add(Pattern.compile("aaa"));
        excludes.add(Pattern.compile("bb"));
        TreeSet<IncludeTableFilter> includes = new TreeSet<IncludeTableFilter>();
        includes.add(new IncludeTableFilter(null, PatternFilter.INCLUDE_EVERYTHING));
        TableFilter filter = new TableFilter(includes, excludes);
        TableFilterTest.assertNull((Object)filter.isIncludeTable("aaa"));
        TableFilterTest.assertNotNull((Object)filter.isIncludeTable("aa"));
        TableFilterTest.assertNotNull((Object)filter.isIncludeTable("aaaa"));
        TableFilterTest.assertNull((Object)filter.isIncludeTable("bb"));
        TableFilterTest.assertNotNull((Object)filter.isIncludeTable(""));
        TableFilterTest.assertNotNull((Object)filter.isIncludeTable("bbbb"));
    }

    public void testIncludeExclude() {
        TreeSet<Pattern> excludes = new TreeSet<Pattern>(PatternFilter.PATTERN_COMPARATOR);
        excludes.add(Pattern.compile("aaa"));
        excludes.add(Pattern.compile("bb"));
        TreeSet<IncludeTableFilter> includes = new TreeSet<IncludeTableFilter>();
        includes.add(new IncludeTableFilter("aa.*"));
        TableFilter filter = new TableFilter(includes, excludes);
        TableFilterTest.assertNull((Object)filter.isIncludeTable("aaa"));
        TableFilterTest.assertNotNull((Object)filter.isIncludeTable("aa"));
        TableFilterTest.assertNotNull((Object)filter.isIncludeTable("aaaa"));
        TableFilterTest.assertNull((Object)filter.isIncludeTable("bb"));
        TableFilterTest.assertNull((Object)filter.isIncludeTable(""));
        TableFilterTest.assertNull((Object)filter.isIncludeTable("bbbb"));
    }
}

