/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader.filters;

import junit.framework.TestCase;
import org.apache.cayenne.access.loader.filters.PatternFilter;

public class PatternFilterTest
extends TestCase {
    public void testInclude() throws Exception {
        PatternFilter filter = new PatternFilter().include("aaa").include("bbb");
        PatternFilterTest.assertTrue((boolean)filter.isInclude("aaa"));
        PatternFilterTest.assertTrue((boolean)filter.isInclude("bbb"));
        PatternFilterTest.assertFalse((boolean)filter.isInclude("aaaa"));
        PatternFilterTest.assertFalse((boolean)filter.isInclude("aa"));
        PatternFilterTest.assertFalse((boolean)filter.isInclude("abb"));
        filter = new PatternFilter().include("^v_.*$");
        PatternFilterTest.assertTrue((boolean)filter.isInclude("v_new_view"));
        PatternFilterTest.assertFalse((boolean)filter.isInclude("new_view"));
        PatternFilterTest.assertFalse((boolean)filter.isInclude("view"));
        PatternFilterTest.assertFalse((boolean)filter.isInclude("girl"));
    }

    public void testExclude() throws Exception {
        PatternFilter filter = new PatternFilter().exclude("aaa").exclude("bbb");
        PatternFilterTest.assertFalse((boolean)filter.isInclude("aaa"));
        PatternFilterTest.assertFalse((boolean)filter.isInclude("bbb"));
        PatternFilterTest.assertTrue((boolean)filter.isInclude("aaaa"));
        PatternFilterTest.assertTrue((boolean)filter.isInclude("aa"));
        PatternFilterTest.assertTrue((boolean)filter.isInclude("abb"));
    }

    public void testIncludeExclude() throws Exception {
        PatternFilter filter = new PatternFilter().include("aa.*").exclude("aaa");
        PatternFilterTest.assertFalse((boolean)filter.isInclude("aaa"));
        PatternFilterTest.assertFalse((boolean)filter.isInclude("bbb"));
        PatternFilterTest.assertTrue((boolean)filter.isInclude("aaaa"));
        PatternFilterTest.assertTrue((boolean)filter.isInclude("aa"));
        PatternFilterTest.assertFalse((boolean)filter.isInclude("abb"));
    }

    public void testIncludeAllFilter() {
        PatternFilterTest.assertTrue((boolean)PatternFilter.INCLUDE_EVERYTHING.isInclude("qwe"));
        PatternFilterTest.assertTrue((boolean)PatternFilter.INCLUDE_EVERYTHING.isInclude(""));
        PatternFilterTest.assertTrue((boolean)PatternFilter.INCLUDE_EVERYTHING.isInclude(null));
    }

    public void testIncludeNoneFilter() {
        PatternFilterTest.assertFalse((boolean)PatternFilter.INCLUDE_NOTHING.isInclude("qwe"));
        PatternFilterTest.assertFalse((boolean)PatternFilter.INCLUDE_NOTHING.isInclude(""));
        PatternFilterTest.assertFalse((boolean)PatternFilter.INCLUDE_NOTHING.isInclude(null));
    }
}

