/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader.filters;

import org.apache.commons.lang.StringUtils;

public class OldFilterConfigBridge {
    private String catalog;
    private String schema;
    private String includeTableFilters;
    private String includeColumnFilters;
    private String includeProceduresFilters;
    private String excludeTableFilters;
    private String excludeColumnFilters;
    private String excludeProceduresFilters;
    private boolean loadProcedures;

    public OldFilterConfigBridge catalog(String catalog) {
        this.catalog = catalog;
        return this;
    }

    public String catalog() {
        return this.catalog;
    }

    public OldFilterConfigBridge schema(String schema) {
        this.schema = schema;
        return this;
    }

    public String schema() {
        return this.schema;
    }

    public OldFilterConfigBridge includeTables(String tableFilters) {
        if (StringUtils.isBlank((String)tableFilters)) {
            return this;
        }
        this.includeTableFilters = OldFilterConfigBridge.transform(tableFilters);
        return this;
    }

    public OldFilterConfigBridge includeColumns(String columnFilters) {
        if (StringUtils.isBlank((String)columnFilters)) {
            return this;
        }
        this.includeColumnFilters = OldFilterConfigBridge.transform(columnFilters);
        return this;
    }

    public OldFilterConfigBridge includeProcedures(String proceduresFilters) {
        if (StringUtils.isBlank((String)proceduresFilters)) {
            return this;
        }
        this.includeProceduresFilters = OldFilterConfigBridge.transform(proceduresFilters);
        return this;
    }

    public OldFilterConfigBridge excludeTables(String tableFilters) {
        if (StringUtils.isBlank((String)tableFilters)) {
            return this;
        }
        this.excludeTableFilters = OldFilterConfigBridge.transform(tableFilters);
        return this;
    }

    public OldFilterConfigBridge excludeColumns(String columnFilters) {
        if (StringUtils.isBlank((String)columnFilters)) {
            return this;
        }
        this.excludeColumnFilters = OldFilterConfigBridge.transform(columnFilters);
        return this;
    }

    public OldFilterConfigBridge excludeProcedures(String proceduresFilters) {
        if (StringUtils.isBlank((String)proceduresFilters)) {
            return this;
        }
        this.excludeProceduresFilters = OldFilterConfigBridge.transform(proceduresFilters);
        return this;
    }

    private static String transform(String pattern) {
        return "^" + pattern.replaceAll("[*?]", ".$0") + "$";
    }

    public void setProceduresFilters(boolean loadProcedures) {
        this.loadProcedures = loadProcedures;
    }

    public String getIncludeTableFilters() {
        return this.includeTableFilters;
    }

    public String getIncludeColumnFilters() {
        return this.includeColumnFilters;
    }

    public String getIncludeProceduresFilters() {
        return this.includeProceduresFilters;
    }

    public String getExcludeTableFilters() {
        return this.excludeTableFilters;
    }

    public String getExcludeColumnFilters() {
        return this.excludeColumnFilters;
    }

    public String getExcludeProceduresFilters() {
        return this.excludeProceduresFilters;
    }

    public boolean isLoadProcedures() {
        return this.loadProcedures;
    }
}

