/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader.filters;

import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.cayenne.access.loader.filters.CatalogFilter;
import org.apache.cayenne.access.loader.filters.FiltersConfig;
import org.apache.cayenne.access.loader.filters.IncludeTableFilter;
import org.apache.cayenne.access.loader.filters.PatternFilter;
import org.apache.cayenne.access.loader.filters.SchemaFilter;
import org.apache.cayenne.access.loader.filters.TableFilter;

public class FiltersConfigTest
extends TestCase {
    public void testToString_01() {
        FiltersConfig config = FiltersConfig.create(null, null, TableFilter.everything(), PatternFilter.INCLUDE_EVERYTHING);
        FiltersConfigTest.assertEquals((String)"Catalog: null\n  Schema: null\n    Tables: \n      Include: null Columns: ALL\n    Procedures: ALL\n", (String)config.toString());
    }

    public void testToString_02() {
        FiltersConfig config = new FiltersConfig(new CatalogFilter("catalog_01", new SchemaFilter("schema_11", TableFilter.everything(), PatternFilter.INCLUDE_EVERYTHING)), new CatalogFilter("catalog_02", new SchemaFilter("schema_21", TableFilter.everything(), PatternFilter.INCLUDE_NOTHING), new SchemaFilter("schema_22", new TableFilter(this.includes(new IncludeTableFilter(null, PatternFilter.INCLUDE_NOTHING)), this.excludes("aaa")), PatternFilter.INCLUDE_NOTHING), new SchemaFilter("schema_23", TableFilter.include("include"), PatternFilter.INCLUDE_NOTHING)));
        FiltersConfigTest.assertEquals((String)"Catalog: catalog_01\n  Schema: schema_11\n    Tables: \n      Include: null Columns: ALL\n    Procedures: ALL\nCatalog: catalog_02\n  Schema: schema_21\n    Tables: \n      Include: null Columns: ALL\n    Procedures: NONE\n  Schema: schema_22\n    Tables: \n      Include: null Columns: NONE\n      aaa\n    Procedures: NONE\n  Schema: schema_23\n    Tables: \n      Include: include Columns: ALL\n    Procedures: NONE\n", (String)config.toString());
    }

    private SortedSet<Pattern> excludes(String ... p) {
        TreeSet<Pattern> patterns = new TreeSet<Pattern>(PatternFilter.PATTERN_COMPARATOR);
        for (String pattern : p) {
            patterns.add(PatternFilter.pattern(pattern));
        }
        return patterns;
    }

    protected SortedSet<IncludeTableFilter> includes(IncludeTableFilter ... filters) {
        TreeSet<IncludeTableFilter> includeTableFilters = new TreeSet<IncludeTableFilter>();
        Collections.addAll(includeTableFilters, filters);
        return includeTableFilters;
    }
}

