/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.cayenne.access.DbLoaderDelegate;
import org.apache.cayenne.access.loader.DbAttributesLoader;
import org.apache.cayenne.access.loader.DbLoaderConfiguration;
import org.apache.cayenne.access.loader.filters.PatternFilter;
import org.apache.cayenne.access.loader.filters.TableFilter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DetectedDbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbTableLoader {
    private static final Log LOGGER = LogFactory.getLog(DbTableLoader.class);
    private static final String WILDCARD = "%";
    private final String catalog;
    private final String schema;
    private final DatabaseMetaData metaData;
    private final DbLoaderDelegate delegate;
    private final DbAttributesLoader attributesLoader;

    public DbTableLoader(String catalog, String schema, DatabaseMetaData metaData, DbLoaderDelegate delegate, DbAttributesLoader attributesLoader) {
        this.catalog = catalog;
        this.schema = schema;
        this.metaData = metaData;
        this.delegate = delegate;
        this.attributesLoader = attributesLoader;
    }

    public List<DetectedDbEntity> getDbEntities(TableFilter filters, String[] types) throws SQLException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Read tables: catalog=" + this.catalog + ", schema=" + this.schema + ", types=" + Arrays.toString(types)));
        }
        LinkedList<DetectedDbEntity> tables = new LinkedList<DetectedDbEntity>();
        try (ResultSet rs = this.metaData.getTables(this.catalog, this.schema, WILDCARD, types);){
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                if (name == null) continue;
                DetectedDbEntity table = new DetectedDbEntity(name);
                String catalog = rs.getString("TABLE_CAT");
                table.setCatalog(catalog);
                String schema = rs.getString("TABLE_SCHEM");
                table.setSchema(schema);
                if (this.catalog != null && !this.catalog.equals(catalog) || this.schema != null && !this.schema.equals(schema)) {
                    LOGGER.error((Object)(catalog + "." + schema + "." + name + " wrongly loaded for catalog/schema : " + this.catalog + "." + this.schema));
                    continue;
                }
                PatternFilter includeTable = filters.isIncludeTable(table.getName());
                if (includeTable == null) continue;
                tables.add(table);
            }
        }
        return tables;
    }

    public List<DbEntity> loadDbEntities(DataMap map, DbLoaderConfiguration config, String[] types) throws SQLException {
        List<DetectedDbEntity> tables = this.getDbEntities(config.getFiltersConfig().tableFilter(this.catalog, this.schema), types);
        ArrayList<DbEntity> dbEntities = new ArrayList<DbEntity>();
        for (DbEntity dbEntity : tables) {
            DbEntity oldEnt = map.getDbEntity(dbEntity.getName());
            if (oldEnt != null) {
                Collection<ObjEntity> oldObjEnt = map.getMappedEntities(oldEnt);
                if (!oldObjEnt.isEmpty()) {
                    for (ObjEntity objEntity : oldObjEnt) {
                        LOGGER.debug((Object)("Delete ObjEntity: " + objEntity.getName()));
                        map.removeObjEntity(objEntity.getName(), true);
                        this.delegate.objEntityRemoved(objEntity);
                    }
                }
                LOGGER.debug((Object)("Overwrite DbEntity: " + oldEnt.getName()));
                map.removeDbEntity(oldEnt.getName(), true);
                this.delegate.dbEntityRemoved(oldEnt);
            }
            map.addDbEntity(dbEntity);
            this.delegate.dbEntityAdded(dbEntity);
            if (map.getDbEntity(dbEntity.getName()) != dbEntity) continue;
            dbEntities.add(dbEntity);
            this.attributesLoader.loadDbAttributes(dbEntity);
            if (config.isSkipPrimaryKeyLoading()) continue;
            this.loadPrimaryKey(dbEntity);
        }
        return dbEntities;
    }

    private void loadPrimaryKey(DbEntity dbEntity) throws SQLException {
        try (ResultSet rs = this.metaData.getPrimaryKeys(dbEntity.getCatalog(), dbEntity.getSchema(), dbEntity.getName());){
            while (rs.next()) {
                String pkName;
                String columnName = rs.getString("COLUMN_NAME");
                DbAttribute attribute = dbEntity.getAttribute(columnName);
                if (attribute != null) {
                    attribute.setPrimaryKey(true);
                } else {
                    LOGGER.warn((Object)("Can't locate attribute for primary key: " + columnName));
                }
                if ((pkName = rs.getString("PK_NAME")) == null || !(dbEntity instanceof DetectedDbEntity)) continue;
                ((DetectedDbEntity)dbEntity).setPrimaryKeyName(pkName);
            }
        }
    }
}

