/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.apache.cayenne.access.loader.DbAttributesLoader;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;

public abstract class DbAttributesBaseLoader
implements DbAttributesLoader {
    private final String catalog;
    private final String schema;
    private final DatabaseMetaData metaData;
    private final DbAdapter adapter;

    public DbAttributesBaseLoader(String catalog, String schema, DatabaseMetaData metaData, DbAdapter adapter) {
        this.catalog = catalog;
        this.schema = schema;
        this.metaData = metaData;
        this.adapter = adapter;
    }

    protected DbAttribute loadDbAttribute(Set<String> columns, ResultSet rs) throws SQLException {
        String autoIncrement;
        int columnType = rs.getInt("DATA_TYPE");
        int decimalDigits = -1;
        if (TypesMapping.isDecimal(columnType)) {
            decimalDigits = rs.getInt("DECIMAL_DIGITS");
            if (rs.wasNull()) {
                decimalDigits = -1;
            }
        }
        DbAttribute attr = this.adapter.buildAttribute(rs.getString("COLUMN_NAME"), rs.getString("TYPE_NAME"), columnType, rs.getInt("COLUMN_SIZE"), decimalDigits, rs.getBoolean("NULLABLE"));
        if (columns.contains("IS_AUTOINCREMENT") && "YES".equals(autoIncrement = rs.getString("IS_AUTOINCREMENT"))) {
            attr.setGenerated(true);
        }
        return attr;
    }

    @Override
    public void loadDbAttributes(DbEntity entity) {
        for (DbAttribute attr : this.loadDbAttributes(entity.getName())) {
            attr.setEntity(entity);
            if (entity.getAttribute(attr.getName()) != null) {
                entity.removeAttribute(attr.getName());
            }
            entity.addAttribute(attr);
        }
    }

    protected abstract List<DbAttribute> loadDbAttributes(String var1);

    protected String getCatalog() {
        return this.catalog;
    }

    protected String getSchema() {
        return this.schema;
    }

    protected DatabaseMetaData getMetaData() {
        return this.metaData;
    }
}

