/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.enum_test.Enum1;
import org.apache.cayenne.testdo.enum_test.EnumEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-enum.xml")
public class EnumIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;

    private void createDataSet() throws Exception {
        TableHelper tEnumEntity = new TableHelper(this.dbHelper, "ENUM_ENTITY");
        tEnumEntity.setColumns(new String[]{"ID", "ENUM_ATTRIBUTE"});
        tEnumEntity.insert(new Object[]{1, "two"});
        tEnumEntity.insert(new Object[]{2, "one"});
    }

    @Test
    public void testInsert() {
        EnumEntity e = this.context.newObject(EnumEntity.class);
        e.setEnumAttribute(Enum1.one);
        this.context.commitChanges();
    }

    @Test
    public void testSelectQuery() throws Exception {
        this.createDataSet();
        SelectQuery<EnumEntity> q = new SelectQuery<EnumEntity>(EnumEntity.class);
        q.andQualifier(ExpressionFactory.matchExp("enumAttribute", (Object)Enum1.one));
        EnumEntity e = (EnumEntity)Cayenne.objectForQuery(this.context, q);
        Assert.assertNotNull((Object)e);
        Assert.assertSame((Object)((Object)Enum1.one), (Object)((Object)e.getEnumAttribute()));
    }

    @Test
    public void testSQLTemplate() throws Exception {
        this.createDataSet();
        SQLTemplate q = new SQLTemplate(EnumEntity.class, "SELECT * FROM ENUM_ENTITY WHERE ENUM_ATTRIBUTE = 'one'");
        q.setColumnNamesCapitalization(CapsStrategy.UPPER);
        EnumEntity e = (EnumEntity)Cayenne.objectForQuery(this.context, q);
        Assert.assertNotNull((Object)e);
        Assert.assertSame((Object)((Object)Enum1.one), (Object)((Object)e.getEnumAttribute()));
    }
}

