/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collections;
import java.util.HashMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.annotation.PostAdd;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.event.DefaultEventManager;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Exhibit;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.testdo.testmap.annotations.Tag1;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataDomainIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private JdbcEventLogger logger;

    @Test
    public void testName() throws Exception {
        DataDomain domain = new DataDomain("some name");
        Assert.assertEquals((Object)"some name", (Object)domain.getName());
        domain.setName("tst_name");
        Assert.assertEquals((Object)"tst_name", (Object)domain.getName());
    }

    @Test
    public void testLookupDataNode() {
        DataDomain domain = new DataDomain("test");
        DataMap m1 = new DataMap("m1");
        DataNode n1 = new DataNode("n1");
        n1.addDataMap(m1);
        domain.addNode(n1);
        DataMap m2 = new DataMap("m2");
        DataNode n2 = new DataNode("n2");
        n2.addDataMap(m2);
        domain.addNode(n2);
        Assert.assertSame((Object)n1, (Object)domain.lookupDataNode(m1));
        Assert.assertSame((Object)n2, (Object)domain.lookupDataNode(m2));
        try {
            domain.lookupDataNode(new DataMap("m3"));
            Assert.fail((String)"must have thrown on missing Map to Node maping");
        }
        catch (CayenneRuntimeException e) {
            // empty catch block
        }
    }

    @Test
    public void testLookupDataNode_Default() {
        DataDomain domain = new DataDomain("test");
        DataMap m1 = new DataMap("m1");
        DataNode n1 = new DataNode("n1");
        n1.addDataMap(m1);
        domain.setDefaultNode(n1);
        DataMap m2 = new DataMap("m2");
        DataNode n2 = new DataNode("n2");
        n2.addDataMap(m2);
        domain.addNode(n2);
        Assert.assertSame((Object)n1, (Object)domain.lookupDataNode(m1));
        Assert.assertSame((Object)n2, (Object)domain.lookupDataNode(m2));
        Assert.assertSame((Object)n1, (Object)domain.lookupDataNode(new DataMap("m3")));
    }

    @Test
    public void testNodes() throws Exception {
        DataDomain domain = new DataDomain("dom1");
        Assert.assertEquals((long)0L, (long)domain.getDataNodes().size());
        DataNode node = new DataNode("1");
        node.setJdbcEventLogger(this.logger);
        domain.addNode(node);
        Assert.assertEquals((long)1L, (long)domain.getDataNodes().size());
        node = new DataNode("2");
        node.setJdbcEventLogger(this.logger);
        domain.addNode(node);
        Assert.assertEquals((long)2L, (long)domain.getDataNodes().size());
    }

    @Test
    public void testNodeMaps() throws Exception {
        DataDomain domain = new DataDomain("dom1");
        Assert.assertNull((Object)domain.getDataMap("map"));
        DataNode node = new DataNode("1");
        node.setJdbcEventLogger(this.logger);
        node.addDataMap(new DataMap("map"));
        domain.addNode(node);
        Assert.assertNotNull((Object)domain.getDataMap("map"));
    }

    @Test
    public void testMaps() throws Exception {
        DataDomain d1 = new DataDomain("dom1");
        DataMap m1 = new DataMap("m1");
        d1.addDataMap(m1);
        Assert.assertSame((Object)m1, (Object)d1.getDataMap(m1.getName()));
        d1.removeDataMap(m1.getName());
        Assert.assertNull((Object)d1.getDataMap(m1.getName()));
    }

    @Test
    public void testEntityResolverRefresh() throws Exception {
        DataDomain domain = new DataDomain("dom1");
        EntityResolver resolver = domain.getEntityResolver();
        Assert.assertNotNull((Object)resolver);
        DataMap map = new DataMap("map");
        ObjEntity entity = new ObjEntity("TestEntity");
        map.addObjEntity(entity);
        domain.addDataMap(map);
        Assert.assertSame((Object)entity, (Object)resolver.getObjEntity("TestEntity"));
    }

    @Test
    public void testEntityResolver() {
        Assert.assertNotNull((Object)this.runtime.getDataDomain().getEntityResolver());
        DataDomain domain = new DataDomain("dom1");
        Assert.assertNotNull((Object)domain.getEntityResolver());
    }

    @Test
    public void testInitDataDomainWithSharedCache() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cayenne.DataDomain.sharedCache", Boolean.TRUE.toString());
        DataDomain domain = new DataDomain("d1", properties);
        Assert.assertTrue((boolean)domain.isSharedCacheEnabled());
    }

    @Test
    public void testInitDataDomainWithDedicatedCache() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cayenne.DataDomain.sharedCache", Boolean.FALSE.toString());
        DataDomain domain = new DataDomain("d1", properties);
        Assert.assertFalse((boolean)domain.isSharedCacheEnabled());
    }

    @Test
    public void testInitDataDomainValidation() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cayenne.DataDomain.validatingObjectsOnCommit", Boolean.TRUE.toString());
        DataDomain domain = new DataDomain("d1", properties);
        Assert.assertTrue((boolean)domain.isValidatingObjectsOnCommit());
    }

    @Test
    public void testInitDataDomainNoValidation() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cayenne.DataDomain.validatingObjectsOnCommit", Boolean.FALSE.toString());
        DataDomain domain = new DataDomain("d1", properties);
        Assert.assertFalse((boolean)domain.isValidatingObjectsOnCommit());
    }

    @Test
    public void testShutdownCache() {
        DataDomain domain = new DataDomain("X");
        final boolean[] cacheShutdown = new boolean[1];
        DataRowStore cache = new DataRowStore("Y", Collections.EMPTY_MAP, new DefaultEventManager()){

            @Override
            public void shutdown() {
                cacheShutdown[0] = true;
            }
        };
        domain.setSharedSnapshotCache(cache);
        domain.shutdown();
        Assert.assertTrue((boolean)cacheShutdown[0]);
    }

    @Test
    public void testAddListener() {
        DataDomain domain = this.runtime.getDataDomain();
        PostAddListener listener = new PostAddListener();
        domain.addListener(listener);
        ObjectContext context = this.runtime.newContext();
        context.newObject(Gallery.class);
        Assert.assertEquals((Object)"e:Gallery;", (Object)listener.getAndReset());
        context.newObject(Artist.class);
        Assert.assertEquals((Object)"a:Artist;", (Object)listener.getAndReset());
        context.newObject(Exhibit.class);
        Assert.assertEquals((Object)"", (Object)listener.getAndReset());
        context.newObject(Painting.class);
        Assert.assertEquals((Object)"e:Painting;", (Object)listener.getAndReset());
    }

    class PostAddListener {
        StringBuilder callbackBuffer = new StringBuilder();

        PostAddListener() {
        }

        @PostAdd(value={Gallery.class, Painting.class})
        void postAddEntities(Persistent object) {
            this.callbackBuffer.append("e:" + object.getObjectId().getEntityName() + ";");
        }

        @PostAdd(entityAnnotations={Tag1.class})
        void postAddAnnotated(Persistent object) {
            this.callbackBuffer.append("a:" + object.getObjectId().getEntityName() + ";");
        }

        String getAndReset() {
            String v = this.callbackBuffer.toString();
            this.callbackBuffer = new StringBuilder();
            return v;
        }
    }
}

