/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.testdo.testmap.PaintingInfo;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextPrefetchExtras1IT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;

    protected void createDataSet() throws Exception {
        TableHelper tPainting = new TableHelper(this.dbHelper, "PAINTING");
        tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE"});
        TableHelper tPaintingInfo = new TableHelper(this.dbHelper, "PAINTING_INFO");
        tPaintingInfo.setColumns(new String[]{"PAINTING_ID", "TEXT_REVIEW"});
        for (int i = 1; i <= 10; ++i) {
            tPainting.insert(new Object[]{i, "P" + i});
            tPaintingInfo.insert(new Object[]{i, "Review #" + i});
        }
    }

    @Test
    public void testPrefetchToOne() throws Exception {
        this.createDataSet();
        SelectQuery<Painting> query = new SelectQuery<Painting>(Painting.class);
        query.addPrefetch("toPaintingInfo");
        List objects = this.context.performQuery(query);
        Assert.assertTrue((!objects.isEmpty() ? 1 : 0) != 0);
        for (Painting p : objects) {
            PaintingInfo pi = p.getToPaintingInfo();
            Assert.assertEquals((long)3L, (long)p.getPersistenceState());
            Assert.assertEquals((long)3L, (long)pi.getPersistenceState());
        }
    }
}

