/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.Fault;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.ResultBatchIterator;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.ResultIteratorCallback;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.IncrementalFaultList;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Exhibit;
import org.apache.cayenne.testdo.testmap.NullTestEntity;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.testdo.testmap.ROArtist;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.UnitTestClosure;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.ServerCaseDataSourceFactory;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected UnitDbAdapter accessStackAdapter;
    @Inject
    protected DataChannelInterceptor queryInterceptor;
    @Inject
    protected ServerCaseDataSourceFactory dataSourceFactory;
    protected TableHelper tArtist;
    protected TableHelper tExhibit;
    protected TableHelper tGallery;
    protected TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tExhibit = new TableHelper(this.dbHelper, "EXHIBIT");
        this.tExhibit.setColumns(new String[]{"EXHIBIT_ID", "GALLERY_ID", "OPENING_DATE", "CLOSING_DATE"});
        this.tGallery = new TableHelper(this.dbHelper, "GALLERY");
        this.tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "ESTIMATED_PRICE"});
    }

    protected void createSingleArtistDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
    }

    protected void createFiveArtistDataSet_MixedCaseName() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "Artist3"});
        this.tArtist.insert(new Object[]{33003, "aRtist5"});
        this.tArtist.insert(new Object[]{33004, "arTist2"});
        this.tArtist.insert(new Object[]{33005, "artISt4"});
    }

    protected void createGalleriesAndExhibitsDataSet() throws Exception {
        this.tGallery.insert(new Object[]{33001, "gallery1"});
        this.tGallery.insert(new Object[]{33002, "gallery2"});
        this.tGallery.insert(new Object[]{33003, "gallery3"});
        this.tGallery.insert(new Object[]{33004, "gallery4"});
        Timestamp now = new Timestamp(System.currentTimeMillis());
        this.tExhibit.insert(new Object[]{1, 33001, now, now});
        this.tExhibit.insert(new Object[]{2, 33002, now, now});
    }

    protected void createArtistsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "artist2"});
        this.tArtist.insert(new Object[]{33003, "artist3"});
        this.tArtist.insert(new Object[]{33004, "artist4"});
        this.tArtist.insert(new Object[]{33005, "artist5"});
        this.tArtist.insert(new Object[]{33006, "artist11"});
        this.tArtist.insert(new Object[]{33007, "artist21"});
    }

    protected void createLargeArtistsDataSet() throws Exception {
        for (int i = 1; i <= 20; ++i) {
            this.tArtist.insert(new Object[]{i, "artist" + i});
        }
    }

    protected void createArtistsAndPaintingsDataSet() throws Exception {
        this.createArtistsDataSet();
        this.tPainting.insert(new Object[]{33001, "P_artist1", 33001, 1000});
        this.tPainting.insert(new Object[]{33002, "P_artist2", 33002, 2000});
        this.tPainting.insert(new Object[]{33003, "P_artist3", 33003, 3000});
        this.tPainting.insert(new Object[]{33004, "P_artist4", 33004, 4000});
        this.tPainting.insert(new Object[]{33005, "P_artist5", 33005, 5000});
        this.tPainting.insert(new Object[]{33006, "P_artist11", 33006, 11000});
        this.tPainting.insert(new Object[]{33007, "P_artist21", 33007, 21000});
    }

    @Test
    public void testCurrentSnapshot1() throws Exception {
        this.createSingleArtistDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class, ExpressionFactory.matchExp("artistName", "artist1"));
        Artist artist = (Artist)this.context.performQuery(query).get(0);
        DataRow snapshot = this.context.currentSnapshot(artist);
        Assert.assertEquals((Object)artist.getArtistName(), snapshot.get("ARTIST_NAME"));
        Assert.assertEquals((Object)artist.getDateOfBirth(), snapshot.get("DATE_OF_BIRTH"));
    }

    @Test
    public void testCurrentSnapshot2() throws Exception {
        this.createSingleArtistDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class, ExpressionFactory.matchExp("artistName", "artist1"));
        Artist artist = (Artist)this.context.performQuery(query).get(0);
        artist.setArtistName(null);
        artist.setDateOfBirth(null);
        DataRow snapshot = this.context.currentSnapshot(artist);
        Assert.assertTrue((boolean)snapshot.containsKey("ARTIST_NAME"));
        Assert.assertNull(snapshot.get("ARTIST_NAME"));
        Assert.assertTrue((boolean)snapshot.containsKey("DATE_OF_BIRTH"));
        Assert.assertNull(snapshot.get("DATE_OF_BIRTH"));
    }

    @Test
    public void testCurrentSnapshot3() throws Exception {
        this.createSingleArtistDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class, ExpressionFactory.matchExp("artistName", "artist1"));
        Artist artist = (Artist)this.context.performQuery(query).get(0);
        Painting p1 = new Painting();
        this.context.registerNewObject(p1);
        p1.setToArtist(artist);
        DataRow s1 = this.context.currentSnapshot(p1);
        Map<String, Object> idMap = artist.getObjectId().getIdSnapshot();
        Assert.assertEquals((Object)idMap.get("ARTIST_ID"), s1.get("ARTIST_ID"));
    }

    @Test
    public void testCurrentSnapshotWithToOneFault() throws Exception {
        this.createGalleriesAndExhibitsDataSet();
        ObjectId eId = new ObjectId("Exhibit", "EXHIBIT_ID", 2);
        Exhibit e = (Exhibit)this.context.performQuery(new ObjectIdQuery(eId)).get(0);
        Assert.assertTrue((boolean)(e.readPropertyDirectly("toGallery") instanceof Fault));
        DataRow snapshot = this.context.currentSnapshot(e);
        Assert.assertTrue((boolean)(e.readPropertyDirectly("toGallery") instanceof Fault));
        Assert.assertEquals((Object)new Integer(33002), snapshot.get("GALLERY_ID"));
    }

    @Test
    public void testCharFetch() throws Exception {
        this.createSingleArtistDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Artist a = (Artist)this.context.performQuery(query).get(0);
        Assert.assertEquals((Object)a.getArtistName().trim(), (Object)a.getArtistName());
    }

    @Test
    public void testCharInQualifier() throws Exception {
        this.createArtistsDataSet();
        Expression e = ExpressionFactory.matchExp("artistName", "artist1");
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class, e);
        List artists = this.context.performQuery(q);
        Assert.assertEquals((long)1L, (long)artists.size());
    }

    @Test
    public void testMultiObjRelFetch() throws Exception {
        this.createArtistsAndPaintingsDataSet();
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class);
        q.andQualifier(ExpressionFactory.matchExp("toArtist.artistName", "artist2"));
        q.orQualifier(ExpressionFactory.matchExp("toArtist.artistName", "artist4"));
        List results = this.context.performQuery(q);
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testMultiDbRelFetch() throws Exception {
        this.createArtistsAndPaintingsDataSet();
        SelectQuery q = new SelectQuery("Painting");
        q.andQualifier(ExpressionFactory.matchDbExp("toArtist.ARTIST_NAME", "artist2"));
        q.orQualifier(ExpressionFactory.matchDbExp("toArtist.ARTIST_NAME", "artist4"));
        List results = this.context.performQuery(q);
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testSelectDate() throws Exception {
        this.createGalleriesAndExhibitsDataSet();
        List objects = this.context.performQuery(new SelectQuery<Exhibit>(Exhibit.class));
        Assert.assertFalse((boolean)objects.isEmpty());
        Exhibit e1 = (Exhibit)objects.get(0);
        Assert.assertEquals(Date.class, e1.getClosingDate().getClass());
    }

    @Test
    public void testCaseInsensitiveOrdering() throws Exception {
        if (!this.accessStackAdapter.supportsCaseInsensitiveOrder()) {
            return;
        }
        this.createFiveArtistDataSet_MixedCaseName();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        Ordering ordering = new Ordering("artistName", SortOrder.ASCENDING_INSENSITIVE);
        query.addOrdering(ordering);
        query.setDistinct(true);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)5L, (long)objects.size());
        Artist artist = (Artist)objects.get(0);
        DataRow snapshot = this.context.getObjectStore().getSnapshot(artist.getObjectId());
        Assert.assertEquals((long)3L, (long)snapshot.size());
        Assert.assertEquals((Object)"artist1", (Object)((Artist)objects.get(0)).getArtistName());
        Assert.assertEquals((Object)"arTist2", (Object)((Artist)objects.get(1)).getArtistName());
        Assert.assertEquals((Object)"Artist3", (Object)((Artist)objects.get(2)).getArtistName());
        Assert.assertEquals((Object)"artISt4", (Object)((Artist)objects.get(3)).getArtistName());
        Assert.assertEquals((Object)"aRtist5", (Object)((Artist)objects.get(4)).getArtistName());
    }

    @Test
    public void testSelect_DataRows() throws Exception {
        this.createArtistsAndPaintingsDataSet();
        SelectQuery<DataRow> query = SelectQuery.dataRowQuery(Artist.class, null);
        List<DataRow> objects = this.context.select(query);
        Assert.assertNotNull(objects);
        Assert.assertEquals((long)7L, (long)objects.size());
        Assert.assertTrue((String)("DataRow expected, got " + objects.get(0).getClass()), (boolean)(objects.get(0) instanceof DataRow));
    }

    @Test
    public void testPerformSelectQuery1() throws Exception {
        this.createArtistsAndPaintingsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
        Assert.assertEquals((long)7L, (long)objects.size());
        Assert.assertTrue((String)("Artist expected, got " + objects.get(0).getClass()), (boolean)(objects.get(0) instanceof Artist));
    }

    @Test
    public void testPerformSelectQuery2() throws Exception {
        this.createArtistsAndPaintingsDataSet();
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(ExpressionFactory.matchExp("artistName", "artist3"));
        expressions.add(ExpressionFactory.matchExp("artistName", "artist5"));
        expressions.add(ExpressionFactory.matchExp("artistName", "artist21"));
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class, ExpressionFactory.joinExp(1, expressions));
        List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
        Assert.assertEquals((long)3L, (long)objects.size());
        Assert.assertTrue((String)("Artist expected, got " + objects.get(0).getClass()), (boolean)(objects.get(0) instanceof Artist));
    }

    @Test
    public void testPerformQuery_Routing() {
        Query query = (Query)Mockito.mock(Query.class);
        QueryMetadata md = (QueryMetadata)Mockito.mock(QueryMetadata.class);
        Mockito.when((Object)query.getMetaData((EntityResolver)Matchers.any(EntityResolver.class))).thenReturn((Object)md);
        this.context.performGenericQuery(query);
        ((Query)Mockito.verify((Object)query)).route((QueryRouter)Matchers.any(QueryRouter.class), (EntityResolver)Matchers.eq((Object)this.context.getEntityResolver()), (Query)Matchers.isNull());
    }

    @Test
    public void testPerformNonSelectingQuery() throws Exception {
        this.createSingleArtistDataSet();
        SelectQuery<Painting> select = new SelectQuery<Painting>(Painting.class, Expression.fromString("db:PAINTING_ID = 1"));
        Assert.assertEquals((long)0L, (long)this.context.performQuery(select).size());
        SQLTemplate query = new SQLTemplate(Painting.class, "INSERT INTO PAINTING (PAINTING_ID, PAINTING_TITLE, ARTIST_ID, ESTIMATED_PRICE) VALUES (1, 'PX', 33001, 1)");
        this.context.performNonSelectingQuery(query);
        Assert.assertEquals((long)1L, (long)this.context.performQuery(select).size());
    }

    @Test
    public void testPerformNonSelectingQueryCounts1() throws Exception {
        this.createArtistsDataSet();
        SQLTemplate query = new SQLTemplate(Painting.class, "INSERT INTO PAINTING (PAINTING_ID, PAINTING_TITLE, ARTIST_ID, ESTIMATED_PRICE) VALUES ($pid, '$pt', $aid, $price)");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pid", new Integer(1));
        map.put("pt", "P1");
        map.put("aid", new Integer(33002));
        map.put("price", new Double(1.1));
        query.setParameters(map);
        int[] counts = this.context.performNonSelectingQuery(query);
        Assert.assertNotNull((Object)counts);
        Assert.assertEquals((long)1L, (long)counts.length);
        Assert.assertEquals((long)1L, (long)counts[0]);
    }

    @Test
    public void testPerformNonSelectingQueryCounts2() throws Exception {
        this.createArtistsDataSet();
        SQLTemplate query = new SQLTemplate(Painting.class, "INSERT INTO PAINTING (PAINTING_ID, PAINTING_TITLE, ARTIST_ID, ESTIMATED_PRICE) VALUES ($pid, '$pt', $aid, #bind($price 'DECIMAL' 2))");
        Map[] maps = new Map[3];
        for (int i = 0; i < maps.length; ++i) {
            maps[i] = new HashMap();
            maps[i].put("pid", new Integer(1 + i));
            maps[i].put("pt", "P-" + i);
            maps[i].put("aid", new Integer(33002));
            maps[i].put("price", new BigDecimal("1." + i));
        }
        query.setParameters(maps);
        int[] counts = this.context.performNonSelectingQuery(query);
        Assert.assertNotNull((Object)counts);
        Assert.assertEquals((long)maps.length, (long)counts.length);
        for (int i = 0; i < maps.length; ++i) {
            Assert.assertEquals((long)1L, (long)counts[i]);
        }
        SQLTemplate delete = new SQLTemplate(Painting.class, "delete from PAINTING");
        counts = this.context.performNonSelectingQuery(delete);
        Assert.assertNotNull((Object)counts);
        Assert.assertEquals((long)1L, (long)counts.length);
        Assert.assertEquals((long)3L, (long)counts[0]);
    }

    @Test
    public void testPerformPaginatedQuery() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = SelectQuery.query(Artist.class);
        query.setPageSize(5);
        List<Artist> objects = this.context.select(query);
        Assert.assertNotNull(objects);
        Assert.assertTrue((boolean)(objects instanceof IncrementalFaultList));
        Assert.assertTrue((boolean)(((IncrementalFaultList)objects).elements.get(0) instanceof Long));
        Assert.assertTrue((boolean)(((IncrementalFaultList)objects).elements.get(6) instanceof Long));
        Assert.assertTrue((boolean)(objects.get(0) instanceof Artist));
    }

    @Test
    public void testPerformPaginatedQuery1() throws Exception {
        this.createArtistsDataSet();
        EJBQLQuery query = new EJBQLQuery("select a FROM Artist a");
        query.setPageSize(5);
        List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
        Assert.assertTrue((boolean)(objects instanceof IncrementalFaultList));
        Assert.assertTrue((boolean)(((IncrementalFaultList)objects).elements.get(0) instanceof Long));
        Assert.assertTrue((boolean)(((IncrementalFaultList)objects).elements.get(6) instanceof Long));
        Assert.assertTrue((boolean)(objects.get(0) instanceof Artist));
    }

    @Test
    public void testPerformPaginatedQueryBigPage() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.setPageSize(5);
        final List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
        Assert.assertTrue((boolean)(objects instanceof IncrementalFaultList));
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)7L, (long)objects.size());
            }
        });
    }

    @Test
    public void testPerformDataRowQuery() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.setFetchingDataRows(true);
        List objects = this.context.performQuery(query);
        Assert.assertNotNull((Object)objects);
        Assert.assertEquals((long)7L, (long)objects.size());
        Assert.assertTrue((String)("Map expected, got " + objects.get(0).getClass()), (boolean)(objects.get(0) instanceof Map));
    }

    @Test
    public void testCommitChangesRO1() throws Exception {
        ROArtist a1 = (ROArtist)this.context.newObject("ROArtist");
        a1.writePropertyDirectly("artistName", "abc");
        a1.setPersistenceState(4);
        try {
            this.context.commitChanges();
            Assert.fail((String)"Inserting a 'read-only' object must fail.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCommitChangesRO2() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<ROArtist> query = new SelectQuery<ROArtist>(ROArtist.class, ExpressionFactory.matchExp("artistName", "artist1"));
        ROArtist a1 = (ROArtist)this.context.performQuery(query).get(0);
        a1.writeProperty("artistName", "abc");
        try {
            this.context.commitChanges();
            Assert.fail((String)"Updating a 'read-only' object must fail.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCommitChangesRO3() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<ROArtist> query = new SelectQuery<ROArtist>(ROArtist.class, ExpressionFactory.matchExp("artistName", "artist1"));
        ROArtist a1 = (ROArtist)this.context.performQuery(query).get(0);
        this.context.deleteObjects(a1);
        try {
            this.context.commitChanges();
            Assert.fail((String)"Deleting a 'read-only' object must fail.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCommitChangesRO4() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<ROArtist> query = new SelectQuery<ROArtist>(ROArtist.class, ExpressionFactory.matchExp("artistName", "artist1"));
        ROArtist a1 = (ROArtist)this.context.performQuery(query).get(0);
        Painting painting = this.context.newObject(Painting.class);
        painting.setPaintingTitle("paint");
        a1.addToPaintingArray(painting);
        Assert.assertEquals((long)4L, (long)a1.getPersistenceState());
        try {
            this.context.commitChanges();
        }
        catch (Exception ex) {
            Assert.fail((String)("Updating 'read-only' object's to-many must succeed, instead an exception was thrown: " + ex));
        }
        Assert.assertEquals((long)3L, (long)a1.getPersistenceState());
    }

    @Test
    public void testIterate() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> q1 = new SelectQuery<Artist>(Artist.class);
        final int[] count = new int[1];
        this.context.iterate(q1, new ResultIteratorCallback<Artist>(){

            @Override
            public void next(Artist object) {
                Assert.assertNotNull((Object)object.getArtistName());
                count[0] = count[0] + 1;
            }
        });
        Assert.assertEquals((long)7L, (long)count[0]);
    }

    @Test
    public void testIterateDataRows() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<DataRow> q1 = SelectQuery.dataRowQuery(Artist.class, null);
        final int[] count = new int[1];
        this.context.iterate(q1, new ResultIteratorCallback<DataRow>(){

            @Override
            public void next(DataRow object) {
                Assert.assertNotNull(object.get("ARTIST_ID"));
                count[0] = count[0] + 1;
            }
        });
        Assert.assertEquals((long)7L, (long)count[0]);
    }

    @Test
    public void testIterator() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> q1 = new SelectQuery<Artist>(Artist.class);
        try (ResultIterator<Artist> it = this.context.iterator(q1);){
            int count = 0;
            for (Artist a : it) {
                ++count;
            }
            Assert.assertEquals((long)7L, (long)count);
        }
    }

    @Test
    public void testBatchIterator() throws Exception {
        this.createLargeArtistsDataSet();
        SelectQuery<Artist> q1 = new SelectQuery<Artist>(Artist.class);
        try (ResultBatchIterator<Artist> it = this.context.batchIterator(q1, 5);){
            int count = 0;
            for (List<Artist> list : it) {
                ++count;
                Assert.assertEquals((long)5L, (long)list.size());
            }
            Assert.assertEquals((long)4L, (long)count);
        }
    }

    @Test
    public void testPerformIteratedQuery1() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> q1 = new SelectQuery<Artist>(Artist.class);
        try (ResultIterator it = this.context.performIteratedQuery(q1);){
            int count = 0;
            while (it.hasNextRow()) {
                it.nextRow();
                ++count;
            }
            Assert.assertEquals((long)7L, (long)count);
        }
    }

    @Test
    public void testPerformIteratedQuery2() throws Exception {
        this.createArtistsAndPaintingsDataSet();
        try (ResultIterator it = this.context.performIteratedQuery(SelectQuery.query(Artist.class));){
            while (it.hasNextRow()) {
                DataRow row = (DataRow)it.nextRow();
                Artist artist = this.context.objectFromDataRow(Artist.class, row);
                List<Painting> paintings = artist.getPaintingArray();
                Assert.assertNotNull(paintings);
                Assert.assertEquals((String)("Expected one painting for artist: " + artist), (long)1L, (long)paintings.size());
            }
        }
    }

    @Test
    public void testHasChangesPhantom() {
        String artistName = "ArtistName";
        Artist artist = (Artist)this.context.newObject("Artist");
        artist.setArtistName(artistName);
        this.context.commitChanges();
        artist.setArtistName(artistName);
        Assert.assertTrue((boolean)this.context.hasChanges());
    }

    @Test
    public void testHasChangesRealModify() {
        Artist artist = (Artist)this.context.newObject("Artist");
        artist.setArtistName("ArtistName");
        this.context.commitChanges();
        artist.setArtistName("Something different");
        Assert.assertTrue((boolean)this.context.hasChanges());
    }

    @Test
    public void testInvalidateObjects_Vararg() throws Exception {
        DataRow row = new DataRow(10);
        row.put("ARTIST_ID", new Integer(1));
        row.put("ARTIST_NAME", "ArtistXYZ");
        row.put("DATE_OF_BIRTH", new Date());
        DataObject object = this.context.objectFromDataRow(Artist.class, row);
        ObjectId oid = object.getObjectId();
        this.context.getObjectStore().registerNode(oid, object);
        Assert.assertSame((Object)object, (Object)this.context.getObjectStore().getNode(oid));
        Assert.assertNotNull((Object)this.context.getObjectStore().getCachedSnapshot(oid));
        this.context.invalidateObjects(object);
        Assert.assertSame((Object)oid, (Object)object.getObjectId());
        Assert.assertNull((Object)this.context.getObjectStore().getCachedSnapshot(oid));
        Assert.assertSame((Object)object, (Object)this.context.getObjectStore().getNode(oid));
    }

    @Test
    public void testInvalidateObjects() throws Exception {
        DataRow row = new DataRow(10);
        row.put("ARTIST_ID", new Integer(1));
        row.put("ARTIST_NAME", "ArtistXYZ");
        row.put("DATE_OF_BIRTH", new Date());
        DataObject object = this.context.objectFromDataRow(Artist.class, row);
        ObjectId oid = object.getObjectId();
        this.context.getObjectStore().registerNode(oid, object);
        Assert.assertSame((Object)object, (Object)this.context.getObjectStore().getNode(oid));
        Assert.assertNotNull((Object)this.context.getObjectStore().getCachedSnapshot(oid));
        this.context.invalidateObjects((Collection<?>)Collections.singleton(object));
        Assert.assertSame((Object)oid, (Object)object.getObjectId());
        Assert.assertNull((Object)this.context.getObjectStore().getCachedSnapshot(oid));
        Assert.assertSame((Object)object, (Object)this.context.getObjectStore().getNode(oid));
    }

    @Test
    public void testBeforeHollowDeleteShouldChangeStateToCommited() throws Exception {
        this.createSingleArtistDataSet();
        Artist hollow = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 33001);
        this.context.invalidateObjects(hollow);
        Assert.assertEquals((long)5L, (long)hollow.getPersistenceState());
        this.context.deleteObjects(hollow);
        Assert.assertSame((Object)hollow, (Object)this.context.getGraphManager().getNode(new ObjectId("Artist", "ARTIST_ID", 33001)));
        Assert.assertEquals((Object)"artist1", (Object)hollow.getArtistName());
        Assert.assertEquals((long)6L, (long)hollow.getPersistenceState());
    }

    @Test
    public void testCommitUnchangedInsert() throws Exception {
        NullTestEntity newObject = this.context.newObject(NullTestEntity.class);
        Assert.assertTrue((boolean)this.context.hasChanges());
        this.context.commitChanges();
        Assert.assertFalse((boolean)this.context.hasChanges());
        Assert.assertEquals((long)3L, (long)newObject.getPersistenceState());
    }
}

