/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.ArtistExhibit;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.unit.util.TstBean;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class CayenneDataObjectIT
extends ServerCase {
    @Inject
    private ObjectContext context;

    @Test
    public void testSetObjectId() throws Exception {
        CayenneDataObject object = new CayenneDataObject();
        ObjectId oid = new ObjectId("T");
        Assert.assertNull((Object)object.getObjectId());
        object.setObjectId(oid);
        Assert.assertSame((Object)oid, (Object)object.getObjectId());
    }

    @Test
    public void testSetPersistenceState() throws Exception {
        CayenneDataObject obj = new CayenneDataObject();
        Assert.assertEquals((long)1L, (long)obj.getPersistenceState());
        obj.setPersistenceState(3);
        Assert.assertEquals((long)3L, (long)obj.getPersistenceState());
    }

    @Test
    public void testReadNestedProperty1() throws Exception {
        Artist a = new Artist();
        Assert.assertNull((Object)a.readNestedProperty("artistName"));
        a.setArtistName("aaa");
        Assert.assertEquals((Object)"aaa", (Object)a.readNestedProperty("artistName"));
    }

    @Test
    public void testReadNestedPropertyNotPersistentString() throws Exception {
        Artist a = new Artist();
        Assert.assertNull((Object)a.readNestedProperty("someOtherProperty"));
        a.setSomeOtherProperty("aaa");
        Assert.assertEquals((Object)"aaa", (Object)a.readNestedProperty("someOtherProperty"));
    }

    @Test
    public void testReadNestedPropertyNonPersistentNotString() throws Exception {
        Artist a = new Artist();
        Object object = new Object();
        Assert.assertNull((Object)a.readNestedProperty("someOtherObjectProperty"));
        a.setSomeOtherObjectProperty(object);
        Assert.assertSame((Object)object, (Object)a.readNestedProperty("someOtherObjectProperty"));
    }

    @Test
    public void testReadNestedPropertyNonDataObjectPath() {
        CayenneDataObject o1 = new CayenneDataObject();
        TstBean o2 = new TstBean();
        o2.setInteger(new Integer(55));
        o1.writePropertyDirectly("o2", o2);
        Assert.assertSame((Object)o2, (Object)o1.readNestedProperty("o2"));
        Assert.assertEquals((Object)new Integer(55), (Object)o1.readNestedProperty("o2.integer"));
        Assert.assertEquals(TstBean.class, (Object)o1.readNestedProperty("o2.class"));
        Assert.assertEquals((Object)TstBean.class.getName(), (Object)o1.readNestedProperty("o2.class.name"));
    }

    @Test
    public void testReadNestedPropertyToManyInMiddle() throws Exception {
        Artist a = this.context.newObject(Artist.class);
        ArtistExhibit ex = this.context.newObject(ArtistExhibit.class);
        Painting p1 = this.context.newObject(Painting.class);
        Painting p2 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("p1");
        p2.setPaintingTitle("p2");
        a.addToPaintingArray(p1);
        a.addToPaintingArray(p2);
        ex.setToArtist(a);
        List names = (List)a.readNestedProperty("paintingArray.paintingTitle");
        Assert.assertEquals((long)names.size(), (long)2L);
        Assert.assertEquals(names.get(0), (Object)"p1");
        Assert.assertEquals(names.get(1), (Object)"p2");
        List names2 = (List)ex.readNestedProperty("toArtist.paintingArray.paintingTitle");
        Assert.assertEquals((Object)names, (Object)names2);
    }

    @Test
    public void testReadNestedPropertyToManyInMiddle1() throws Exception {
        Artist a = this.context.newObject(Artist.class);
        ArtistExhibit ex = this.context.newObject(ArtistExhibit.class);
        Painting p1 = this.context.newObject(Painting.class);
        Painting p2 = this.context.newObject(Painting.class);
        p1.setPaintingTitle("p1");
        p2.setPaintingTitle("p2");
        a.addToPaintingArray(p1);
        a.addToPaintingArray(p2);
        ex.setToArtist(a);
        List names = (List)a.readNestedProperty("paintingArray+.paintingTitle");
        Assert.assertEquals((long)names.size(), (long)2L);
        Assert.assertEquals(names.get(0), (Object)"p1");
        Assert.assertEquals(names.get(1), (Object)"p2");
        List names2 = (List)ex.readNestedProperty("toArtist.paintingArray+.paintingTitle");
        Assert.assertEquals((Object)names, (Object)names2);
    }

    @Test
    public void testFilterObjects() {
        ArrayList<Painting> paintingList = new ArrayList<Painting>();
        Painting p1 = this.context.newObject(Painting.class);
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("dddAd");
        p1.setToArtist(a1);
        paintingList.add(p1);
        Expression exp = ExpressionFactory.likeExp("toArtist+.artistName", "d%");
        List rezult = exp.filterObjects(paintingList);
        Assert.assertEquals((Object)a1, (Object)((Painting)rezult.get(0)).getToArtist());
    }

    @Test
    public void testFilterObjectsResultIsMutable() {
        ArrayList artistList = new ArrayList();
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("Pablo");
        Expression exp = ExpressionFactory.matchExp("artistName", "Mismatch");
        List<Artist> result = exp.filterObjects(artistList);
        Assert.assertTrue((boolean)result.isEmpty());
        result.add(a);
        Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
    }
}

