/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.Collection;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.RefreshQuery;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.relationships_collection_to_many.CollectionToMany;
import org.apache.cayenne.testdo.relationships_collection_to_many.CollectionToManyTarget;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-relationships-collection-to-many.xml")
public class CDOCollectionRelationshipIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;

    @Before
    public void setUp() throws Exception {
        TableHelper tCollectionToMany = new TableHelper(this.dbHelper, "COLLECTION_TO_MANY");
        tCollectionToMany.setColumns(new String[]{"ID"});
        TableHelper tCollectionToManyTarget = new TableHelper(this.dbHelper, "COLLECTION_TO_MANY_TARGET");
        tCollectionToManyTarget.setColumns(new String[]{"ID", "COLLECTION_TO_MANY_ID"});
        tCollectionToMany.insert(new Object[]{1}).insert(new Object[]{2});
        tCollectionToManyTarget.insert(new Object[]{1, 1}).insert(new Object[]{2, 1}).insert(new Object[]{3, 1}).insert(new Object[]{4, 2});
    }

    @Test
    public void testReadToMany() throws Exception {
        CollectionToMany o1 = Cayenne.objectForPK(this.context, CollectionToMany.class, 1);
        Collection<CollectionToManyTarget> targets = o1.getTargets();
        Assert.assertNotNull(targets);
        Assert.assertTrue((boolean)((ValueHolder)((Object)targets)).isFault());
        Assert.assertEquals((long)3L, (long)targets.size());
        Assert.assertTrue((boolean)targets.contains(Cayenne.objectForPK(o1.getObjectContext(), CollectionToManyTarget.class, 1)));
        Assert.assertTrue((boolean)targets.contains(Cayenne.objectForPK(o1.getObjectContext(), CollectionToManyTarget.class, 2)));
        Assert.assertTrue((boolean)targets.contains(Cayenne.objectForPK(o1.getObjectContext(), CollectionToManyTarget.class, 3)));
    }

    @Test
    public void testReadToManyPrefetching() throws Exception {
        SelectQuery<CollectionToMany> query = new SelectQuery<CollectionToMany>(CollectionToMany.class, ExpressionFactory.matchDbExp("ID", new Integer(1)));
        query.addPrefetch("targets");
        CollectionToMany o1 = (CollectionToMany)Cayenne.objectForQuery(this.context, query);
        Collection<CollectionToManyTarget> targets = o1.getTargets();
        Assert.assertFalse((boolean)((ValueHolder)((Object)targets)).isFault());
        Assert.assertNotNull(targets);
        Assert.assertEquals((long)3L, (long)targets.size());
        Assert.assertTrue((boolean)targets.contains(Cayenne.objectForPK(o1.getObjectContext(), CollectionToManyTarget.class, 1)));
        Assert.assertTrue((boolean)targets.contains(Cayenne.objectForPK(o1.getObjectContext(), CollectionToManyTarget.class, 2)));
        Assert.assertTrue((boolean)targets.contains(Cayenne.objectForPK(o1.getObjectContext(), CollectionToManyTarget.class, 3)));
    }

    @Test
    public void testAddToMany() throws Exception {
        CollectionToMany o1 = Cayenne.objectForPK(this.context, CollectionToMany.class, 1);
        Collection<CollectionToManyTarget> targets = o1.getTargets();
        Assert.assertNotNull(targets);
        Assert.assertEquals((long)3L, (long)targets.size());
        CollectionToManyTarget newTarget = o1.getObjectContext().newObject(CollectionToManyTarget.class);
        o1.addToTargets(newTarget);
        Assert.assertEquals((long)4L, (long)targets.size());
        Assert.assertTrue((boolean)o1.getTargets().contains(newTarget));
        Assert.assertSame((Object)o1, (Object)newTarget.getCollectionToMany());
        o1.getObjectContext().commitChanges();
        o1.getObjectContext().performGenericQuery(new RefreshQuery());
        Assert.assertEquals((long)4L, (long)o1.getTargets().size());
    }

    @Test
    public void testRemoveToMany() throws Exception {
        CollectionToMany o1 = Cayenne.objectForPK(this.context, CollectionToMany.class, 1);
        Collection<CollectionToManyTarget> targets = o1.getTargets();
        Assert.assertEquals((long)3L, (long)targets.size());
        CollectionToManyTarget target = Cayenne.objectForPK(o1.getObjectContext(), CollectionToManyTarget.class, 2);
        o1.removeFromTargets(target);
        Assert.assertEquals((long)2L, (long)targets.size());
        Assert.assertFalse((boolean)o1.getTargets().contains(target));
        Assert.assertNull((Object)target.getCollectionToMany());
        o1.getObjectContext().commitChanges();
        o1.getObjectContext().performGenericQuery(new RefreshQuery());
        Assert.assertEquals((long)2L, (long)o1.getTargets().size());
        Assert.assertFalse((boolean)o1.getTargets().contains(target));
    }

    @Test
    public void testAddToManyViaReverse() throws Exception {
        CollectionToMany o1 = Cayenne.objectForPK(this.context, CollectionToMany.class, 1);
        Collection<CollectionToManyTarget> targets = o1.getTargets();
        Assert.assertNotNull(targets);
        Assert.assertEquals((long)3L, (long)targets.size());
        CollectionToManyTarget newTarget = o1.getObjectContext().newObject(CollectionToManyTarget.class);
        newTarget.setCollectionToMany(o1);
        Assert.assertEquals((long)4L, (long)targets.size());
        Assert.assertTrue((boolean)o1.getTargets().contains(newTarget));
        Assert.assertSame((Object)o1, (Object)newTarget.getCollectionToMany());
        o1.getObjectContext().commitChanges();
        o1.getObjectContext().performGenericQuery(new RefreshQuery());
        Assert.assertEquals((long)4L, (long)o1.getTargets().size());
    }
}

